/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.extension.IX509Extension;
import de.intarsys.security.extension.IX509ExtensionFactory;
import de.intarsys.security.extension.common.GenericX509Extension;
import de.intarsys.security.extension.common.X509ExtensionAuthorityKeyIdentifier;
import de.intarsys.security.extension.common.X509ExtensionBasicConstraints;
import de.intarsys.security.extension.common.X509ExtensionCRLDistributionPoints;
import de.intarsys.security.extension.common.X509ExtensionExtendedKeyUsage;
import de.intarsys.security.extension.common.X509ExtensionKeyUsage;
import de.intarsys.security.extension.common.X509ExtensionSubjectAltNames;
import de.intarsys.security.extension.common.X509ExtensionSubjectKeyIdentifier;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.provider.ProviderTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@SingletonClass
public class X509ExtensionFactory
implements IX509ExtensionFactory {
    private static final String OID_FIELD_NAME = "OID";
    private static IX509ExtensionFactory Instance;
    private Map<String, Class<? extends IX509Extension>> oidMap = new HashMap<String, Class<? extends IX509Extension>>();

    public static synchronized IX509ExtensionFactory get() {
        if (Instance == null) {
            Instance = new X509ExtensionFactory();
        }
        return Instance;
    }

    protected X509ExtensionFactory() {
        this.addOID(X509ExtensionExtendedKeyUsage.class);
        this.addOID(X509ExtensionKeyUsage.class);
        this.addOID(X509ExtensionBasicConstraints.class);
        this.addOID(X509ExtensionSubjectKeyIdentifier.class);
        this.addOID(X509ExtensionAuthorityKeyIdentifier.class);
        this.addOID(X509ExtensionCRLDistributionPoints.class);
        this.addOID(X509ExtensionSubjectAltNames.class);
        Iterator providers = ProviderTools.providers(IX509Extension.class);
        while (providers.hasNext()) {
            IX509Extension provider = (IX509Extension)providers.next();
            this.addOID(provider.getOid(), provider.getClass());
        }
    }

    protected void addOID(Class<? extends IX509Extension> pClass) {
        String oid;
        try {
            Field oidField = pClass.getField(OID_FIELD_NAME);
            oid = (String)oidField.get(new String());
        }
        catch (SecurityException e) {
            return;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("public static field OID must be present", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("public static field OID must be present", e);
        }
        this.addOID(oid, pClass);
    }

    protected void addOID(String oid, Class<? extends IX509Extension> pClass) {
        this.oidMap.put(oid, pClass);
    }

    @Override
    public IX509Extension create(String oid, byte[] derValue) {
        Class<? extends IX509Extension> extensionClass = this.oidMap.get(oid);
        if (extensionClass == null) {
            return new GenericX509Extension(oid, derValue);
        }
        if (derValue == null) {
            try {
                Constructor<? extends IX509Extension> constructor = extensionClass.getConstructor(new Class[0]);
                IX509Extension instance = constructor.newInstance(new Object[0]);
                return instance;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("default constructor must be present", e);
            }
        }
        try {
            Method method = extensionClass.getMethod("create", byte[].class);
            Object instance = method.invoke(extensionClass, new Object[]{derValue});
            return (IX509Extension)instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("public static create(byte[]) must be present", e);
        }
    }
}

