/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public class X509ExtensionAuthorityKeyIdentifier
extends CommonX509Extension {
    public static final String OID = "2.5.29.35";
    private PublicKey publicKey;
    private X500Principal issuerName;
    private BigInteger issuerSerial;

    public static X509ExtensionAuthorityKeyIdentifier create(byte[] encoded) throws IOException {
        try {
            AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)ASN1Tools.create((byte[])encoded));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(aki.getEncoded("DER"));
            RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(keySpecX509);
            return new X509ExtensionAuthorityKeyIdentifier(pubKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    public X509ExtensionAuthorityKeyIdentifier() {
    }

    public X509ExtensionAuthorityKeyIdentifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public X500Principal getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getIssuerSerial() {
        return this.issuerSerial;
    }

    @Override
    public String getOid() {
        return OID;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getValue() throws IOException {
        if (this.getPublicKey() == null) {
            return null;
        }
        AuthorityKeyIdentifier authorityKeyIdentifier = null;
        try {
            if (this.getIssuerName() != null && this.getIssuerSerial() != null) {
                ASN1Primitive name = ASN1Tools.create((byte[])this.getIssuerName().getEncoded());
                GeneralName dirName = new GeneralName(4, (ASN1Encodable)name);
                authorityKeyIdentifier = new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(this.getPublicKey(), new GeneralNames(dirName), this.getIssuerSerial());
            } else {
                authorityKeyIdentifier = new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(this.getPublicKey());
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return authorityKeyIdentifier.getEncoded("DER");
    }

    public void setIssuerName(X500Principal issuerName) {
        this.issuerName = issuerName;
    }

    public void setIssuerSerial(BigInteger issuerSerial) {
        this.issuerSerial = issuerSerial;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }
}

