/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class SubjectAltNamesHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("SubjectAltNamesHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.17";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        GeneralName[] names;
        ASN1Primitive obj = CertificateTools.getExtensionValue(object, this.getOID());
        GeneralNames issuer = GeneralNames.getInstance((Object)obj);
        StringBuilder sb = new StringBuilder();
        if (issuer != null && (names = issuer.getNames()) != null) {
            for (int j = 0; j < names.length; ++j) {
                GeneralName name = names[j];
                int tag = name.getTagNo();
                switch (tag) {
                    case 4: {
                        sb.append("Directory Name: ");
                        break;
                    }
                    case 2: {
                        sb.append("DNS Name: ");
                        break;
                    }
                    case 5: {
                        sb.append("EDI Party Name: ");
                        break;
                    }
                    case 7: {
                        sb.append("IP address: ");
                        break;
                    }
                    case 0: {
                        sb.append("Other Name: ");
                        break;
                    }
                    case 8: {
                        sb.append("registered ID: ");
                        break;
                    }
                    case 1: {
                        sb.append("RFC822 Name: ");
                        break;
                    }
                    case 6: {
                        sb.append("URI: ");
                        break;
                    }
                    case 3: {
                        sb.append("X400 address: ");
                    }
                }
                sb.append(CertificateTools.toString(name)).append(StringTools.LS);
            }
        }
        return sb.toString();
    }
}

