/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.IQCStatementsHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.currency.Iso4217;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public class QCStatementsHandler
extends CommonX509ExtensionHandler
implements IQCStatementsHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("QCStatementsHandler.Label", new Object[0]);
    }

    @Override
    public String getMonetaryLimit(X509Extension object) throws IOException {
        QCStatement statement = this.getStatement(object, QCStatement.id_etsi_qcs_LimiteValue);
        if (statement == null) {
            return null;
        }
        MonetaryValue limit = MonetaryValue.getInstance((Object)statement.getStatementInfo());
        Iso4217CurrencyCode currency = limit.getCurrency();
        double value = limit.getAmount().doubleValue() * Math.pow(10.0, limit.getExponent().doubleValue());
        String c = null;
        if (currency.isAlphabetic()) {
            c = currency.getAlphabetic();
        } else {
            int numeric = currency.getNumeric();
            c = Iso4217.Numeric2Alphabetic((int)numeric);
        }
        return c + " " + value;
    }

    @Override
    public String getOID() {
        return "1.3.6.1.5.5.7.1.3";
    }

    protected QCStatement getStatement(X509Extension object, ASN1ObjectIdentifier id) throws IOException {
        ASN1Sequence derQCStatements = (ASN1Sequence)CertificateTools.getExtensionValue(object, this.getOID());
        if (derQCStatements == null) {
            return null;
        }
        Enumeration e = derQCStatements.getObjects();
        while (e.hasMoreElements()) {
            ASN1Encodable derQCStatement = (ASN1Encodable)e.nextElement();
            QCStatement statement = QCStatement.getInstance((Object)derQCStatement);
            if (!id.equals((ASN1Primitive)statement.getStatementId())) continue;
            return statement;
        }
        return null;
    }

    protected QCStatement[] getStatements(X509Extension object) throws IOException {
        ASN1Sequence derQCStatements = (ASN1Sequence)CertificateTools.getExtensionValue(object, this.getOID());
        if (derQCStatements == null) {
            return new QCStatement[0];
        }
        ArrayList<QCStatement> statements = new ArrayList<QCStatement>();
        Enumeration e = derQCStatements.getObjects();
        while (e.hasMoreElements()) {
            ASN1Encodable derQCStatement = (ASN1Encodable)e.nextElement();
            QCStatement statement = QCStatement.getInstance((Object)derQCStatement);
            statements.add(statement);
        }
        return statements.toArray(new QCStatement[statements.size()]);
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Sequence derQCStatements = (ASN1Sequence)CertificateTools.getExtensionValue(object, this.getOID());
        if (derQCStatements == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Enumeration e = derQCStatements.getObjects();
        while (e.hasMoreElements()) {
            ASN1Encodable derQCStatement = (ASN1Encodable)e.nextElement();
            QCStatement statement = QCStatement.getInstance((Object)derQCStatement);
            if (QCStatement.id_etsi_qcs_QcCompliance.equals((ASN1Primitive)statement.getStatementId())) {
                sb.append("Certificate is a EU qualified certificate").append(StringTools.LS);
                continue;
            }
            if (QCStatement.id_etsi_qcs_LimiteValue.equals((ASN1Primitive)statement.getStatementId())) {
                MonetaryValue limit = MonetaryValue.getInstance((Object)statement.getStatementInfo());
                Iso4217CurrencyCode currency = limit.getCurrency();
                double value = limit.getAmount().doubleValue() * Math.pow(10.0, limit.getExponent().doubleValue());
                sb.append("Monetary limit: ");
                String c = null;
                if (currency.isAlphabetic()) {
                    c = currency.getAlphabetic();
                } else {
                    int numeric = currency.getNumeric();
                    c = Iso4217.Numeric2Alphabetic((int)numeric);
                }
                sb.append(c).append(" ").append(value).append(StringTools.LS);
                continue;
            }
            if (QCStatement.id_etsi_qcs_RetentionPeriod.equals((ASN1Primitive)statement.getStatementId())) {
                ASN1Integer value = (ASN1Integer)statement.getStatementInfo();
                sb.append("Retention period: ").append(value.getPositiveValue().intValue()).append(StringTools.LS);
                continue;
            }
            if (QCStatement.id_etsi_qcs_QcSSCD.equals((ASN1Primitive)statement.getStatementId())) {
                sb.append("Private key related to the certified public key resides in a QSCD").append(StringTools.LS);
                continue;
            }
            if (QCStatement.id_etsi_qcs_QcPds.equals((ASN1Primitive)statement.getStatementId())) {
                sb.append("Location of Public-key infrastructure Disclosure Statements (PDSs): ");
                sb.append(StringTools.LS);
                ASN1Sequence uris = ASN1Sequence.getInstance((Object)statement.getStatementInfo());
                Iterator i = uris.iterator();
                while (i.hasNext()) {
                    ASN1Encodable element = (ASN1Encodable)i.next();
                    String lang = "?";
                    String uri = "?";
                    if (element instanceof ASN1Sequence) {
                        ASN1Sequence uriAndLang = ASN1Sequence.getInstance((Object)element);
                        uri = String.valueOf(uriAndLang.getObjectAt(0));
                        lang = String.valueOf(uriAndLang.getObjectAt(1));
                    } else {
                        uri = String.valueOf(element);
                        if (i.hasNext()) {
                            element = (ASN1Encodable)i.next();
                            lang = String.valueOf(element);
                        }
                    }
                    sb.append("-- ").append(lang).append(": ").append(uri).append(StringTools.LS);
                }
                continue;
            }
            if (QCStatement.id_etsi_qcs_QcType.equals((ASN1Primitive)statement.getStatementId())) {
                sb.append("Certificate is a European Union qualified certificate of type:");
                sb.append(StringTools.LS);
                ASN1Sequence typeDef = ASN1Sequence.getInstance((Object)statement.getStatementInfo());
                for (ASN1Encodable claimedType : typeDef) {
                    sb.append("-- ");
                    if (QCStatement.id_etsi_qct_esign.equals(claimedType)) {
                        sb.append("Certificate for electronic signatures as defined in Regulation (EU) No 910/2014");
                    } else if (QCStatement.id_etsi_qct_eseal.equals(claimedType)) {
                        sb.append("Certificate for electronic seals as defined in Regulation (EU) No 910/2014");
                    } else if (QCStatement.id_etsi_qct_web.equals(claimedType)) {
                        sb.append("Certificate for website authentication as defined in Regulation (EU) No 910/2014");
                    } else {
                        sb.append(claimedType);
                    }
                    sb.append(StringTools.LS);
                }
                continue;
            }
            if (QCStatement.id_qcs_pkixQCSyntax_v1.equals((ASN1Primitive)statement.getStatementId())) {
                sb.append("PKIX QC Syntax: v1").append(StringTools.LS);
                continue;
            }
            if (QCStatement.id_qcs_pkixQCSyntax_v2.equals((ASN1Primitive)statement.getStatementId())) {
                sb.append("PKIX QC Syntax: v2").append(StringTools.LS);
                continue;
            }
            sb.append("<").append(statement.getStatementId()).append(">").append(StringTools.LS);
        }
        return sb.toString();
    }
}

