/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.date.DateTools;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Primitive;

public class DateOfCertGenHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);

    @Override
    public String getLabel() {
        return Msg.getString("DateOfCertGenHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "1.3.36.8.3.1";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        Date date;
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.getOID());
        ASN1GeneralizedTime derValue = ASN1GeneralizedTime.getInstance((Object)value);
        if (derValue == null) {
            return null;
        }
        try {
            date = derValue.getDate();
        }
        catch (ParseException e) {
            return super.getStringValue(object);
        }
        if (date == null) {
            return super.getStringValue(object);
        }
        return FORMATTER.format(DateTools.toLocalDateTime((Date)date));
    }
}

