/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.GeneralName;

public class AuthorityInfoAccessHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("AuthorityInfoAccessHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "1.3.6.1.5.5.7.1.1";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.getOID());
        AuthorityInformationAccess aia = null;
        try {
            aia = AuthorityInformationAccess.getInstance((Object)value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        if (aia == null) {
            return null;
        }
        AccessDescription[] ads = aia.getAccessDescriptions();
        if (ads == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ads.length; ++i) {
            AccessDescription ad = ads[i];
            if (ad.getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) {
                sb.append("Access method: ").append("OCSP").append(StringTools.LS);
            }
            if (ad.getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_caIssuers)) {
                sb.append("Access method: ").append("CA Issuers").append(StringTools.LS);
            }
            GeneralName location = ad.getAccessLocation();
            sb.append("Access location: ").append(CertificateTools.toString(location)).append(StringTools.LS);
            sb.append(StringTools.LS);
        }
        return sb.toString();
    }
}

