/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.crl.common.CommonX509CRL;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509JDKCRL
extends CommonX509CRL {
    private X509CRL crl;

    public X509JDKCRL(X509CRL crl) {
        this.crl = crl;
    }

    @Override
    public byte[] basicGetEncoded() throws CRLException {
        return this.crl.getEncoded();
    }

    @Override
    public byte[] getCertInfoList() throws CRLException {
        return this.crl.getTBSCertList();
    }

    public Set getCriticalExtensionOIDs() {
        return this.crl.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.crl.getExtensionValue(oid);
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.crl.getIssuerX500Principal();
    }

    @Override
    public Date getNextUpdate() {
        return this.crl.getNextUpdate();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.crl.getNonCriticalExtensionOIDs();
    }

    protected X509CRLEntry getRevokedCertificate(BigInteger serialNumber) throws CRLException {
        try {
            return this.crl.getRevokedCertificate(serialNumber);
        }
        catch (RuntimeException e) {
            throw new CRLException(e);
        }
    }

    @Override
    public X509CRLEntry getRevokedCertificate(IX509Certificate certificate) throws CRLException {
        return this.getRevokedCertificate(certificate.getSerialNumber());
    }

    @Override
    public Set getRevokedCertificates() throws CRLException {
        try {
            return this.crl.getRevokedCertificates();
        }
        catch (RuntimeException e) {
            throw new CRLException(e);
        }
    }

    @Override
    public String getSigAlgName() {
        Provider prov = Security.getProvider("BC");
        String algName = prov.getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
        if (algName != null) {
            return algName;
        }
        Provider[] provs = Security.getProviders();
        for (int i = 0; i != provs.length; ++i) {
            algName = provs[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (algName == null) continue;
            return algName;
        }
        return this.getSigAlgOID();
    }

    @Override
    public String getSigAlgOID() {
        return this.crl.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.crl.getSigAlgParams();
    }

    @Override
    public byte[] getSignature() {
        return this.crl.getSignature();
    }

    @Override
    public Date getThisUpdate() {
        return this.crl.getThisUpdate();
    }

    @Override
    public int getVersion() {
        return this.crl.getVersion();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.crl.hasUnsupportedCriticalExtension();
    }

    @Override
    public boolean isRevoked(IX509Certificate cert) throws CRLException {
        return this.getRevokedCertificate(cert) != null;
    }

    @Override
    public X509CRL toJavaCRL() throws CRLException {
        return this.crl;
    }
}

