/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.crl.common.Permission;
import de.intarsys.tools.infoset.IElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Permissions {
    private static final String ELEM_PERMISSION = "permission";
    private static final String ATTR_PERMISSION_NAME = "name";
    private static final String ATTR_PERMISSION_VALUE = "value";
    private Map permissions = new HashMap();

    public static Permissions parse(IElement ePermissions) {
        Permissions permissions = new Permissions();
        Iterator permissionElements = ePermissions.elementIterator(ELEM_PERMISSION);
        while (permissionElements.hasNext()) {
            IElement ePermission = (IElement)permissionElements.next();
            String name = ePermission.attributeValue(ATTR_PERMISSION_NAME, null);
            String value = ePermission.attributeValue(ATTR_PERMISSION_VALUE, null);
            permissions.setPermission(new Permission(name, Boolean.parseBoolean(value)));
        }
        return permissions;
    }

    public Permission getPermission(String name) {
        return (Permission)this.permissions.get(name);
    }

    public Map getPermissions() {
        return new HashMap(this.permissions);
    }

    public boolean isPermitted(String name, boolean defaultValue) {
        Permission permission = this.getPermission(name);
        if (permission == null) {
            return defaultValue;
        }
        return permission.getValue();
    }

    public void serialize(IElement ePermissions) {
        for (Permission permission : this.permissions.values()) {
            IElement ePermission = ePermissions.newElementMapped(ELEM_PERMISSION);
            ePermission.setAttributeValue(ATTR_PERMISSION_NAME, permission.getName());
            ePermission.setAttributeValue(ATTR_PERMISSION_VALUE, String.valueOf(permission.getValue()));
        }
    }

    public void setPermission(Permission permission) {
        this.permissions.put(permission.getName(), permission);
    }

    public int size() {
        return this.permissions.size();
    }
}

