/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.CRLCache;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBasedCRLCache
extends CRLCache {
    private static final String CRL = ".crl";
    private static final Logger Log = LoggerFactory.getLogger(DirectoryBasedCRLCache.class);
    private boolean dirty = true;

    @Override
    public void addCRL(IX509CRL crl) {
        super.addCRL(crl);
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void restore(File directory) {
        if (!directory.exists()) {
            return;
        }
        this.clear();
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(DirectoryBasedCRLCache.CRL);
            }
        });
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                IX509CRL crl = X509CertificateFactory.get().createCRL(is);
                this.addCRL(crl);
            }
            catch (IOException iOException) {
                StreamTools.close((Closeable)is);
                continue;
            }
            catch (CRLException cRLException) {
                StreamTools.close((Closeable)is);
                continue;
                {
                    catch (Throwable throwable) {
                        StreamTools.close(is);
                        throw throwable;
                    }
                }
            }
            StreamTools.close((Closeable)is);
            continue;
        }
        this.dirty = false;
    }

    public void store(File directory) throws IOException {
        if (!this.dirty) {
            return;
        }
        Collection<IX509CRL> crls = this.getCRLs();
        FileTools.deleteRecursivly((File)directory);
        directory.mkdir();
        int index = 0;
        for (IX509CRL crl : crls) {
            try {
                byte[] crlBytes = crl.getEncoded();
                FileTools.write((File)new File(directory, String.valueOf(index) + CRL), (byte[])crlBytes);
            }
            catch (CRLException e) {
                Log.warn("failed to serialize CRL", (Throwable)e);
            }
            ++index;
        }
        this.dirty = false;
    }
}

