/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.ldap;

import de.intarsys.security.ldap.LDAPAddress;
import java.security.cert.CertStoreParameters;

public class LDAPCertStoreParameters
implements CertStoreParameters {
    private LDAPAddress address;

    public LDAPCertStoreParameters(LDAPAddress address) {
        this.address = address;
    }

    public LDAPCertStoreParameters(String host) {
        this.address = new LDAPAddress(host);
    }

    public LDAPCertStoreParameters(String host, int port) {
        this.address = new LDAPAddress(host, port);
    }

    public LDAPCertStoreParameters(String host, int port, String baseDN) {
        this.address = new LDAPAddress(host, port, baseDN);
    }

    public LDAPCertStoreParameters(String host, String baseDN) {
        this.address = new LDAPAddress(host, baseDN);
    }

    @Override
    public Object clone() {
        return new LDAPCertStoreParameters((LDAPAddress)this.address.clone());
    }

    public LDAPAddress getAddress() {
        return this.address;
    }

    public String getBaseDN() {
        return this.getAddress().getBaseDN();
    }

    public String getHost() {
        return this.getAddress().getHost();
    }

    public int getPort() {
        return this.getAddress().getPort();
    }

    public String getUrl() {
        return this.getAddress().getUrl();
    }
}

