/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.trustrepository;

import de.intarsys.security.certificate.ITrustBase;
import de.intarsys.security.certificate.TrustBaseTools;
import de.intarsys.security.certificate.common.TrustBase;
import de.intarsys.security.certificate.provider.CertificateProviderRegistry;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.EagerInitializableCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProvider;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.security.certificate.trustrepository.ITrustRepository;
import de.intarsys.security.certificate.trustrepository.PACKAGE;
import de.intarsys.tools.concurrent.EagerInitializable;
import de.intarsys.tools.concurrent.EagerInitializer;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonObject;
import de.intarsys.tools.json.JsonReader;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyStoreException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrustRepository
implements ITrustRepository {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(DefaultTrustRepository.class);
    private final CompositeCertificateProvider providers = new CompositeCertificateProvider("trustRepository");
    private ILocator keystoresDir;

    protected ICertificateProvider createProvider(ILocator trustStoreLocator) {
        try {
            IKeyStore keyStore = KeyStoreFactory.get().create(trustStoreLocator);
            if (keyStore == null) {
                return null;
            }
            keyStore.load();
            ILocator descLocator = trustStoreLocator.getParent().getChild(trustStoreLocator.getName() + ".desc");
            ITrustBase trustBase = this.createTrustBase(descLocator);
            KeyStoreCertificateProvider provider = (KeyStoreCertificateProvider)keyStore.getCertificateProvider();
            if (trustBase != null) {
                provider.setLabel(trustBase.getLabel());
                TrustBaseTools.setTrustBase(provider, trustBase);
            }
            return new EagerInitializableCertificateProvider(provider);
        }
        catch (ConversionException | IOException | KeyStoreException e) {
            Log.warn(e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITrustBase createTrustBase(ILocator desc) throws IOException, ConversionException {
        if (!desc.exists()) {
            return null;
        }
        Reader r = null;
        try {
            r = desc.getReader();
            JsonReader jsonReader = new JsonReader(r);
            JsonObject jsonDesc = jsonReader.readJsonObject();
            TrustBase trustBase = new TrustBase(jsonDesc.getString("type", "unkown"));
            JsonArray trustedApplications = jsonDesc.getJSONArray("trustedApplications");
            for (int i = 0; i < trustedApplications.size(); ++i) {
                trustBase.addTrustedApplication(trustedApplications.getString(i));
            }
            TrustBase trustBase2 = trustBase;
            return trustBase2;
        }
        finally {
            StreamTools.close((Closeable)r);
        }
    }

    public ILocator getKeystoresDir() {
        return this.keystoresDir;
    }

    @Override
    public ICertificateProvider getRootCertificates() {
        return this.providers;
    }

    @Override
    public ICertificateProvider getRootCertificates(String type) {
        return this.providers.getCertificateProviders().stream().map(prov -> {
            if (prov instanceof EagerInitializableCertificateProvider) {
                return ((EagerInitializableCertificateProvider)prov).getDelegate();
            }
            return prov;
        }).filter(prov -> {
            ITrustBase trustBase = TrustBaseTools.getTrustBase(prov);
            return trustBase != null && type.equals(trustBase.getType());
        }).reduce(new CompositeCertificateProvider("trustRepository"), (all, provider) -> {
            ((CompositeCertificateProvider)all).registerCertificateProvider((ICertificateProvider)provider);
            return all;
        });
    }

    @PostConstruct
    public void init() {
        ILocator locator = this.getKeystoresDir();
        if (locator == null) {
            locator = new ClassLoaderResourceLocator(this.getClass().getClassLoader(), "truststores");
        }
        try {
            this.installKeystores(locator);
        }
        catch (IOException e) {
            throw new InitializationException((Throwable)e);
        }
        for (ICertificateProvider provider : this.providers.getCertificateProviders()) {
            if (!(provider instanceof EagerInitializable)) continue;
            ((EagerInitializable)provider).initialize((ExecutorService)EagerInitializer.get());
        }
        CertificateProviderRegistry.get().registerCertificateProvider(this.getRootCertificates());
    }

    protected void installKeystore(ILocator trustStoreLocator) {
        ICertificateProvider provider = this.createProvider(trustStoreLocator);
        if (provider == null) {
            return;
        }
        this.providers.registerCertificateProvider(provider);
    }

    protected void installKeystores(ILocator baseDir) throws IOException {
        ILocator[] trustStoreLocators = baseDir.listLocators((parent, name) -> name.endsWith(".keystore"));
        Stream.of(trustStoreLocators).forEach(trustStoreLocator -> this.installKeystore((ILocator)trustStoreLocator));
    }

    public void setKeystoresDir(ILocator keystoresDir) {
        this.keystoresDir = keystoresDir;
    }
}

