/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.info;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.info.IPublicKeyInfo;
import de.intarsys.security.certificate.info.X500SimpleName;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.functor.IArgs;
import java.math.BigInteger;
import java.util.Date;

public class X509CertificateInfo
implements IPublicKeyInfo,
IStringEvaluator {
    private IX509Certificate certificate;
    private X500SimpleName subject;
    private X500SimpleName issuer;

    public X509CertificateInfo(IX509Certificate certificate) {
        this.certificate = certificate;
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.getExpressionEvaluator().evaluate(expression, args);
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public IStringEvaluator getExpressionEvaluator() {
        MapResolver resolver = new MapResolver(true);
        resolver.put("subject", (Object)this.getSubject());
        resolver.put("issuer", (Object)this.getIssuer());
        resolver.put("notBefore", (Object)this.getNotBefore());
        resolver.put("notAfter", (Object)this.getNotAfter());
        resolver.put("serialNumber", (Object)this.getSerialNumber());
        return resolver;
    }

    @Override
    public X500SimpleName getIssuer() {
        if (this.issuer == null) {
            this.issuer = new X500SimpleName(this.getCertificate().getIssuerX500Principal());
        }
        return this.issuer;
    }

    @Override
    public Date getNotAfter() {
        return this.getCertificate().getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.getCertificate().getNotBefore();
    }

    public BigInteger getSerialNumber() {
        return this.getCertificate().getSerialNumber();
    }

    @Override
    public X500SimpleName getSubject() {
        if (this.subject == null) {
            this.subject = new X500SimpleName(this.getCertificate().getSubjectX500Principal());
        }
        return this.subject;
    }

    @Override
    public boolean isSelfSigned() {
        return this.getCertificate().getSubjectX500Principal().toString().equals(this.getCertificate().getIssuerX500Principal().toString());
    }
}

