/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.creation;

import de.intarsys.security.certificate.creation.IKeyPairGenerator;
import de.intarsys.tools.crypto.CryptoTools;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class ECKeyPairGenerator
implements IKeyPairGenerator {
    private int keySize = 1024;

    public ECKeyPairGenerator() {
    }

    public ECKeyPairGenerator(int keySize) {
        this.keySize = keySize;
    }

    @Override
    public KeyPair generateKeyPair() throws GeneralSecurityException {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"prime192v1");
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC", "BC");
        g.initialize((AlgorithmParameterSpec)ecSpec, CryptoTools.createSecureRandom());
        return g.generateKeyPair();
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }
}

