/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.tools.stream.ConcatInputStream;
import de.intarsys.tools.stream.LogInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ReopenInputStream
extends InputStream {
    private final InputStream input;
    private final InputStream active;
    private final ByteArrayOutputStream bos;

    public ReopenInputStream(InputStream input) {
        this.input = input;
        this.bos = new ByteArrayOutputStream();
        this.active = new LogInputStream(input, (OutputStream)this.bos);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.input.close();
    }

    @Override
    public int read() throws IOException {
        return this.active.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.active.read(b, off, len);
    }

    public InputStream rewind() {
        ConcatInputStream concatIS = new ConcatInputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        concatIS.addInput((InputStream)bis);
        concatIS.addInput(this.active);
        return concatIS;
    }
}

