/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificateFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.attribute.X509V1AttributeCertificate;
import de.intarsys.security.certificate.common.X509V3PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.X509CRL;
import de.intarsys.security.crl.common.X509JDKCRL;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.stream.ConcatInputStream;
import de.intarsys.tools.stream.LogInputStream;
import de.intarsys.tools.stream.StreamTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DefaultX509CertificateFactory
implements IX509CertificateFactory {
    private static final Logger Log = LoggerFactory.getLogger(DefaultX509CertificateFactory.class);
    private CertificateFactory factory;

    @Override
    public IX509AttributeCertificate createAttributeCertificate(InputStream is) throws CertificateException {
        AttributeCertificate cert;
        try {
            cert = (AttributeCertificate)ASN1BasedTools.create((ASN1Based.Factory)AttributeCertificate.FACTORY, (InputStream)is);
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
        return new X509V1AttributeCertificate(cert);
    }

    protected CertificateList createBcCertificateList(InputStream inputStream) throws CRLException {
        BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
        bufferedStream.mark(Integer.MAX_VALUE);
        try {
            ASN1InputStream asn1In = new ASN1InputStream((InputStream)bufferedStream);
            ASN1Primitive asn1Object = asn1In.readObject();
            if (asn1Object == null) {
                throw new CRLException("empty CRL");
            }
            return CertificateList.getInstance((Object)asn1Object);
        }
        catch (IOException asn1In) {
        }
        catch (IllegalArgumentException ex) {
            throw new CRLException(ex);
        }
        StreamTools.reset((BufferedInputStream)bufferedStream);
        PemReader pemReader = new PemReader((Reader)new InputStreamReader(bufferedStream));
        try {
            PemObject pemObject = pemReader.readPemObject();
            if (pemObject == null) {
                throw new CRLException("unparseable CRL");
            }
            return CertificateList.getInstance((Object)pemObject.getContent());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new CRLException(ex);
        }
    }

    @Override
    public IX509Certificate createCertificate(InputStream is) throws CertificateException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LogInputStream logIS = new LogInputStream(is, (OutputStream)bos);
        try {
            return this.createPublicKeyCertificate((InputStream)logIS);
        }
        catch (Exception exception) {
            ConcatInputStream concatIS = new ConcatInputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            concatIS.addInput((InputStream)bis);
            concatIS.addInput(is);
            return this.createAttributeCertificate((InputStream)concatIS);
        }
    }

    @Override
    public IX509CRL createCRL(InputStream is) throws CRLException {
        BufferedInputStream bufferedStream = new BufferedInputStream(is);
        bufferedStream.mark(Integer.MAX_VALUE);
        try {
            return new X509CRL(this.createBcCertificateList(bufferedStream));
        }
        catch (CRLException ex) {
            if (Log.isEnabledForLevel(Level.TRACE)) {
                StreamTools.reset((BufferedInputStream)bufferedStream);
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    byte[] b = new byte[100000];
                    int bytesRead = bufferedStream.read(b);
                    while (bytesRead != -1) {
                        outputStream.write(b, 0, bytesRead);
                        bytesRead = bufferedStream.read(b);
                    }
                    byte[] bytes = outputStream.toByteArray();
                    if (bytes.length > 0) {
                        Log.trace("error reading crl {}", (Object)HexTools.bytesToHexDump((byte[])bytes, (int)0, (int)bytes.length, (int)8, (int)2, (boolean)true, (boolean)true));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    @Override
    public IX509CRL createCRL(java.security.cert.X509CRL crl) {
        if (crl == null) {
            return null;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(crl.getEncoded());
            return this.createCRL(is);
        }
        catch (CRLException e) {
            return new X509JDKCRL(crl);
        }
    }

    @Override
    public IX509PublicKeyCertificate createPublicKeyCertificate(InputStream is) throws CertificateException {
        CertificateFactory cf = this.getFactory();
        try {
            X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
            if (cert == null) {
                throw new CertificateException("Error parsing certificate");
            }
            return new X509V3PublicKeyCertificate(cert);
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public IX509PublicKeyCertificate createPublicKeyCertificate(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        return new X509V3PublicKeyCertificate(certificate);
    }

    protected CertificateFactory getFactory() throws CertificateException {
        if (this.factory == null) {
            try {
                this.factory = CertificateFactory.getInstance("X509", "BC");
            }
            catch (NoSuchProviderException e) {
                this.factory = CertificateFactory.getInstance("X509");
            }
        }
        return this.factory;
    }
}

