/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelectorIdentity;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import java.util.Iterator;

public abstract class CommonCertificateProvider
implements ICertificateProvider,
IPresentationSupport,
INotificationSupport {
    private EventDispatcher dispatcher;

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher((Object)this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public boolean containsCertificate(IX509Certificate certificate) {
        X509CertificateSelectorIdentity selector = new X509CertificateSelectorIdentity(certificate);
        Iterator<IX509Certificate> certificates = this.lookupCertificates(selector);
        return certificates.hasNext();
    }

    public String getDescription() {
        return this.getLabel();
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return "?";
    }

    public String getTip() {
        return this.getLabel();
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
        if (this.dispatcher.isEmpty()) {
            this.dispatcher = null;
        }
    }

    protected void triggerChanged() {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"", null, null));
    }
}

