/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.asn1.x509.attr.Attributes;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509CertificateReference;
import de.intarsys.security.certificate.attribute.CommonX509AttributeCertificate;
import de.intarsys.security.certificate.attribute.X509AttributeCertificateIssuer;
import de.intarsys.security.certificate.attribute.X509AttributeCertificateSubject;
import de.intarsys.security.certificate.attribute.X509AttributeFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;

public class X509V1AttributeCertificate
extends CommonX509AttributeCertificate {
    private AttributeCertificate cert;
    private Date notBefore;
    private Date notAfter;
    private IX509CertificateReference issuer;
    private IX509CertificateReference subject;
    private byte[] sigAlgParams;

    public X509V1AttributeCertificate(AttributeCertificate cert) throws CertificateException {
        this.cert = cert;
        try {
            this.notAfter = cert.getAttributeCertificateInfo().getAttrCertValidityPeriod().getNotAfterTime().getTime();
            this.notBefore = cert.getAttributeCertificateInfo().getAttrCertValidityPeriod().getNotBeforeTime().getTime();
            this.issuer = new X509AttributeCertificateIssuer(cert.getAttributeCertificateInfo().getIssuer());
            this.sigAlgParams = cert.getSignatureAlgorithm().getParametersEncoded();
            this.subject = new X509AttributeCertificateSubject(cert.getAttributeCertificateInfo().getSubject());
        }
        catch (IOException e) {
            throw new CertificateException("invalid data structure in certificate!", e);
        }
    }

    @Override
    public byte[] getCertificateInfo() throws CertificateEncodingException {
        try {
            return this.cert.getAttributeCertificateInfo().getDEREncoded();
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e);
        }
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.cert.getDEREncoded();
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e);
        }
    }

    private Set getExtensionOIDs(boolean critical) {
        X509Extensions extensions = this.cert.getAttributeCertificateInfo().getExtensions();
        if (extensions != null) {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (ext.isCritical() != critical) continue;
                set.add(oid.getId());
            }
            return set;
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        X509Extensions extensions = this.cert.getAttributeCertificateInfo().getExtensions();
        if (extensions != null && (ext = extensions.getExtension(new ASN1ObjectIdentifier(oid))) != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream dOut = ASN1OutputStream.create((OutputStream)bOut, (String)"DER");
            try {
                dOut.writeObject((ASN1Primitive)ext.getValue());
                return bOut.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }

    @Override
    public IX509CertificateReference getIssuer() {
        return this.issuer;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        DERBitString id = this.cert.getAttributeCertificateInfo().getIssuerUniqueId();
        return CertificateTools.parseUniqueId(id);
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.getIssuer().getSubjectX500Principal();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public Date getNotAfter() {
        return this.notAfter;
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.cert.getAttributeCertificateInfo().getSerialNumber().getValue();
    }

    @Override
    public String getSigAlgOID() {
        return this.cert.getSignatureAlgorithm().getAlgorithm();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.sigAlgParams;
    }

    @Override
    public byte[] getSignature() {
        return this.cert.getSignatureValue();
    }

    @Override
    public IX509CertificateReference getSubject() {
        return this.subject;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.getSubject().getSubjectX500Principal();
    }

    @Override
    public int getVersion() {
        return this.cert.getAttributeCertificateInfo().getVersion().getIntValue() + 1;
    }

    @Override
    public IX509Attribute getX509Attribute(String oid) {
        Attributes attributes = this.cert.getAttributeCertificateInfo().getAttributes();
        Attribute attr = attributes.get(oid);
        if (attr == null) {
            return null;
        }
        return X509AttributeFactory.get().create(attr);
    }

    @Override
    public IX509Attribute[] getX509Attributes() {
        Attributes attributes = this.cert.getAttributeCertificateInfo().getAttributes();
        Attribute[] attrs = attributes.getAll();
        IX509Attribute[] x509Attrs = new IX509Attribute[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            x509Attrs[i] = X509AttributeFactory.get().create(attrs[i]);
        }
        return x509Attrs;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extensions = this.getCriticalExtensionOIDs();
        return extensions != null && !extensions.isEmpty();
    }
}

