/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.Attributes;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.attribute.AbstractSingleValueAttribute;
import de.intarsys.security.certificate.attribute.X509AttributeFactory;
import org.bouncycastle.asn1.ASN1Encodable;

public class SubjectDirectoryAttributes
extends AbstractSingleValueAttribute {
    public static final String OID = "2.5.29.9";

    public SubjectDirectoryAttributes(Attribute attribute) {
        super(attribute);
    }

    public IX509Attribute getAttribute(int index) {
        Attribute subAttr = this.getAttributes().get(index);
        return X509AttributeFactory.get().create(subAttr);
    }

    public IX509Attribute getAttribute(String oid) {
        Attributes attributes = this.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = attributes.get(i);
            if (!attr.getAttrType().equals(oid)) continue;
            return X509AttributeFactory.get().create(attr);
        }
        return null;
    }

    public Attributes getAttributes() {
        ASN1ValueHolder asn1Object = this.getAttribute().getAttrValue(0);
        return (Attributes)Attributes.FACTORY.create((ASN1Encodable)asn1Object);
    }

    public int getAttributesSize() {
        return this.getAttributes().size();
    }

    @Override
    public String getLabel() {
        return Msg.getString("SubjectDirectoryAttributes.Label", new Object[0]);
    }

    @Override
    public String getStringValue() {
        StringBuilder sb = new StringBuilder();
        IX509Attribute[] attributes = this.getX509Attributes();
        for (int i = 0; i < attributes.length; ++i) {
            IX509Attribute attr = attributes[i];
            sb.append(attr.getLabel()).append(": ").append(attr.getStringValue()).append("\n");
        }
        return sb.toString();
    }

    protected IX509Attribute[] getX509Attributes() {
        Attributes attributes = this.getAttributes();
        if (attributes == null || attributes.size() == 0) {
            return new IX509Attribute[0];
        }
        IX509Attribute[] result = new IX509Attribute[attributes.size()];
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = attributes.get(i);
            result[i] = X509AttributeFactory.get().create(attr);
        }
        return result;
    }
}

