/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.DirectoryString;
import de.intarsys.asn1.common.GeneralName;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import org.bouncycastle.asn1.ASN1Encodable;

public class ProcurationSyntax
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public String getCountry() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 1, true);
        if (value == null) {
            return null;
        }
        return value.toASN1PrintableString().getString();
    }

    public GeneralName getSigningForGeneralName() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 3, true);
        if (!this.testSigningForIsIssuerSerial(value)) {
            return (GeneralName)GeneralName.FACTORY.create((ASN1Encodable)value);
        }
        return null;
    }

    public IssuerSerial getSigningForIssuerSerial() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 3, true);
        if (this.testSigningForIsIssuerSerial(value)) {
            return (IssuerSerial)IssuerSerial.FACTORY.create((ASN1Encodable)value);
        }
        return null;
    }

    public String getTypeOfSubstitution() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 2, true);
        if (value == null) {
            return null;
        }
        return ((DirectoryString)DirectoryString.FACTORY.create((ASN1Encodable)value)).getString();
    }

    public boolean isSigningForGeneralName() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 3, true);
        return !this.testSigningForIsIssuerSerial(value);
    }

    public boolean isSigningForIssuerSerial() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 3, true);
        return this.testSigningForIsIssuerSerial(value);
    }

    private boolean testSigningForIsIssuerSerial(ASN1ValueHolder value) {
        return value != null && !value.isTagged();
    }

    public static class Factory
    extends ASN1Based.Factory<ProcurationSyntax> {
    }
}

