/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes;

import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.PACKAGE;
import de.intarsys.security.standard.validation.VSQualification;
import de.intarsys.security.standard.validation.VSQualificationDefault;
import de.intarsys.security.standard.validation.VSTimestamp;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.tools.message.IMessageBundle;
import java.util.List;

public abstract class QESTimestampReviewer
implements IReviewer<ITimestampToken, IVSTimestamp> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private int severity;

    public QESTimestampReviewer() {
        this(0);
    }

    public QESTimestampReviewer(int pSeverity) {
        this.severity = pSeverity;
    }

    public int getSeverity() {
        return this.severity;
    }

    protected abstract CommonPKIProfile getValidityPolicy();

    @Override
    public IVSTimestamp review(ITimestampToken timestamp, IVSTimestamp state, IValidationParameters parameters) {
        if (timestamp == null || state == null) {
            return state;
        }
        VSTimestamp newState = new VSTimestamp(state);
        IVSQualification qState = this.validate(state);
        newState.setQualificationState(qState);
        return newState;
    }

    public IVSQualification validate(IVSTimestamp state) {
        VSQualificationDefault qState = new VSQualificationDefault(0);
        qState.setValidityPolicyID(this.getValidityPolicy());
        qState.setSeverity(this.getSeverity());
        this.validate(state, qState);
        return qState;
    }

    protected void validate(IVSTimestamp state, VSQualification qState) {
        IVSSignatureContainer sigState = state.getSignatureState();
        if (sigState == null) {
            qState.increaseState(2);
            qState.addMessage(ValidationMessage.createError(Msg.getString("QESTimestampReviewer.signature.signatureStateMissing", new Object[0])));
        } else {
            List<IVSSignatureContainerEntry> sigEntryStates = sigState.getEntryStates();
            if (sigEntryStates == null) {
                qState.invalidate(Msg.getString("QESTimestampReviewer.signature.entryStatesMissing", new Object[0]));
            } else {
                for (IVSSignatureContainerEntry sigEntryState : sigEntryStates) {
                    this.validateSignatureEntryState((IVSSignatureEntry)sigEntryState, qState);
                }
            }
        }
    }

    protected void validateSignatureEntryState(IVSSignatureEntry sigEntryState, VSQualification qState) {
        IVSQualification sigQState = sigEntryState.getQualificationState();
        if (sigQState == null) {
            qState.increaseState(2);
            qState.addMessage(ValidationMessage.createError(Msg.getString("QESTimestampReviewer.signature.qsStateMissing", new Object[0])));
        } else if (this.getValidityPolicy() != sigQState.getValidityPolicyID()) {
            qState.increaseState(2);
            qState.addMessage(ValidationMessage.createError(Msg.getString("QESTimestampReviewer.signature.qsStateMissingPolicy", new Object[]{this.getValidityPolicy().getDescription()})));
        } else {
            qState.increaseState(sigQState.getState());
        }
    }
}

