/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.commonpki.qes.ExtensionProfile;
import de.intarsys.security.app.validation.commonpki.qes.IExtensionProfile;
import de.intarsys.security.app.validation.commonpki.qes.IExtensionProfileSet;
import de.intarsys.security.app.validation.commonpki.qes.Requirement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ExtensionProfileSet
implements IExtensionProfileSet {
    private Map<String, IExtensionProfile> profiles = new HashMap<String, IExtensionProfile>();

    public static IExtensionProfileSet createCommonPKICorePublicKeyCertificate(EnumKeyPurpose keyPurpose) {
        ExtensionProfileSet profileSet = new ExtensionProfileSet();
        return profileSet;
    }

    public static IExtensionProfileSet createCommonPKISigGPublicKeyCertificate(EnumKeyPurpose keyPurpose) {
        ExtensionProfileSet profileSet = (ExtensionProfileSet)ExtensionProfileSet.createCommonPKICorePublicKeyCertificate(keyPurpose);
        profileSet.registerExtensionProfile(new ExtensionProfile("KeyUsage", "2.5.29.15", Requirement.MUST, Requirement.MUST, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("CertificatePolicies", "2.5.29.32", Requirement.SHOULD_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("SubjectDirectoryAttributes", "2.5.29.9", Requirement.MUST_NOT, Requirement.MAY, Requirement.MUST));
        if (keyPurpose != EnumKeyPurpose.TIMESTAMPING) {
            profileSet.registerExtensionProfile(new ExtensionProfile("QCStatements", "1.3.6.1.5.5.7.1.3", Requirement.SHOULD_NOT, Requirement.MUST, Requirement.MUST));
        }
        profileSet.registerExtensionProfile(new ExtensionProfile("OCSPNocheck", "1.3.6.1.5.5.7.48.1.5", Requirement.SHOULD_NOT, Requirement.MUST_NOT, Requirement.SHOULD));
        profileSet.registerExtensionProfile(new ExtensionProfile("LiabilityLimitationFlag", "0.2.262.1.10.12.0", Requirement.SHOULD_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("DateOfCertGen", "1.3.36.8.3.1", Requirement.MUST_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("Procuration", "1.3.36.8.3.2", Requirement.MUST_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("Admission", "1.3.36.8.3.3", Requirement.MUST_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("MonetaryLimit", "1.3.36.8.3.4", Requirement.SHOULD_NOT, Requirement.MUST_NOT, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("DeclarationOfMajority", "1.3.36.8.3.5", Requirement.MUST_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("Restriction", "1.3.36.8.3.8", Requirement.SHOULD_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("AdditionalInformation", "1.3.36.8.3.15", Requirement.SHOULD_NOT, Requirement.MAY, Requirement.MUST));
        profileSet.registerExtensionProfile(new ExtensionProfile("ICCSN", "1.3.36.8.3.6", Requirement.MUST_NOT, Requirement.MAY, Requirement.MAY));
        return profileSet;
    }

    public static IExtensionProfileSet createDefault() {
        ExtensionProfileSet profileSet = new ExtensionProfileSet();
        return profileSet;
    }

    @Override
    public IExtensionProfile[] getExtensionProfiles() {
        return new ArrayList<IExtensionProfile>(this.profiles.values()).toArray(new IExtensionProfile[this.profiles.size()]);
    }

    @Override
    public IExtensionProfile lookupExtensionProfile(String oid) {
        return this.profiles.get(oid);
    }

    @Override
    public void registerExtensionProfile(IExtensionProfile extensionProfile) {
        this.profiles.put(extensionProfile.getOid(), extensionProfile);
    }

    @Override
    public void unregisterExtensionProfile(IExtensionProfile extensionProfile) {
        this.profiles.remove(extensionProfile.getOid());
    }
}

