/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.common.CommonValidationContextFactory;
import de.intarsys.security.app.validation.common.DefaultSignatureContainerEntryValidator;
import de.intarsys.security.app.validation.common.DefaultSignatureContainerValidator;
import de.intarsys.security.app.validation.common.EnumForceValidationLevel;
import de.intarsys.security.app.validation.common.IStateCachingStrategy;
import de.intarsys.security.app.validation.common.StateCachingStrategy;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.CertificateAttributesChecker;
import de.intarsys.security.app.validation.commonpki.CertificateICCSNChecker;
import de.intarsys.security.app.validation.commonpki.CertificatePoliciesChecker;
import de.intarsys.security.app.validation.commonpki.CommonPKICRLService;
import de.intarsys.security.app.validation.commonpki.CommonPKICertificatePathBuilder;
import de.intarsys.security.app.validation.commonpki.CommonPKICertificatePathValidator;
import de.intarsys.security.app.validation.commonpki.CommonPKICertificateValidator;
import de.intarsys.security.app.validation.commonpki.CommonPKIOCSPService;
import de.intarsys.security.app.validation.commonpki.CommonPKIOCSPTools;
import de.intarsys.security.app.validation.commonpki.CommonPKISignatureEntryValidator;
import de.intarsys.security.app.validation.commonpki.CommonPKITimestampValidator;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonClass
public class CommonPKIValidationContextFactory
extends CommonValidationContextFactory {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CommonPKIValidationContextFactory.class);
    public static final String ARG_CHECK_CRL = "checkCRL";
    public static final String ARG_CHECK_OCSP = "checkOCSP";
    public static final String ARG_OCSP_DEPTH = "ocspDepth";
    public static final String ARG_OCSP_WARN_ON_NO_URL = "ocspWarnOnNoURL";
    public static final String ARG_OCSP_DEFAULT_ACCEPT_PERIOD = "ocspDefaultAcceptPeriod";
    public static final String ARG_HTTP_CONNECT_TIMEOUT = "httpConnectTimeout";
    public static final String ARG_HTTP_READ_TIMEOUT = "httpReadTimeout";
    public static final String ARG_ACCEPT_INTERMEDIATE_TRUSTANCHOR = "acceptIntermediateTrustAnchor";
    public static final String ARG_STOP_ON_INTERMEDIATE_TRUSTANCHOR = "stopOnIntermediateTrustAnchor";
    public static final String ARG_VALIDATE_CERTIFICATES = "validateCertificates";
    public static final String ARG_VALIDATE_TIMESTAMPS = "validateTimestamps";
    public static final String ARG_FORCE_VALIDATION = "forceValidation";
    public static final String ARG_STATE_CACHING_STRATEGY = "stateCachingStrategy";
    private static final CommonPKIValidationContextFactory Instance = new CommonPKIValidationContextFactory();
    private IArgs defaultArgs;

    public static CommonPKIValidationContextFactory get() {
        return Instance;
    }

    protected IArgs applyDefaults(IArgs args) {
        args = args.copy();
        ArgTools.putAllIfAbsent((IArgs)args, (IArgs)this.getDefaultArgs());
        return args;
    }

    @Override
    protected IValidationContext basicCreateValidationContext(IArgs args) {
        args = this.applyDefaults(args);
        ValidationContext context = new ValidationContext();
        context.setArgs(args);
        IStateCachingStrategy stateCachingStrategy = (IStateCachingStrategy)args.get(ARG_STATE_CACHING_STRATEGY);
        if (stateCachingStrategy == null) {
            EnumForceValidationLevel forceValidationLevel = (EnumForceValidationLevel)ArgTools.getEnumItem((IArgs)args, (EnumMeta)EnumForceValidationLevel.META, (String)ARG_FORCE_VALIDATION, (EnumItem)EnumForceValidationLevel.FULL);
            stateCachingStrategy = StateCachingStrategy.basic(forceValidationLevel);
        }
        DefaultSignatureContainerValidator signatureContainerValidator = new DefaultSignatureContainerValidator();
        signatureContainerValidator.setStateCachingStrategy(stateCachingStrategy);
        signatureContainerValidator.setArgs(args);
        context.setSignatureContainerValidator(signatureContainerValidator);
        DefaultSignatureContainerEntryValidator signatureContainerEntryValidator = new DefaultSignatureContainerEntryValidator();
        signatureContainerEntryValidator.setArgs(args);
        context.setSignatureContainerEntryValidator(signatureContainerEntryValidator);
        CommonPKISignatureEntryValidator signatureEntryValidator = new CommonPKISignatureEntryValidator(args);
        signatureEntryValidator.setStateCachingStrategy(stateCachingStrategy);
        signatureEntryValidator.setValidateCertificates(ArgTools.getBoolStrict((IArgs)args, (String)ARG_VALIDATE_CERTIFICATES, (boolean)true));
        signatureEntryValidator.setValidateTimestamps(ArgTools.getBoolStrict((IArgs)args, (String)ARG_VALIDATE_TIMESTAMPS, (boolean)true));
        context.setSignatureEntryValidator(signatureEntryValidator);
        CommonPKICertificateValidator certificateValidator = new CommonPKICertificateValidator();
        context.setCertificateValidator(certificateValidator);
        CommonPKICertificatePathBuilder certificatePathBuilder = new CommonPKICertificatePathBuilder();
        certificatePathBuilder.setAcceptIntermediateTrustAnchor(ArgTools.getBoolStrict((IArgs)args, (String)ARG_ACCEPT_INTERMEDIATE_TRUSTANCHOR, (boolean)true));
        certificatePathBuilder.setStopOnIntermediateTrustAnchor(ArgTools.getBoolStrict((IArgs)args, (String)ARG_STOP_ON_INTERMEDIATE_TRUSTANCHOR, (boolean)false));
        context.setCertificatePathBuilder(certificatePathBuilder);
        CommonPKICertificatePathValidator certificatePathValidator = new CommonPKICertificatePathValidator();
        certificatePathValidator.addCertificateChecker(new CertificatePoliciesChecker());
        certificatePathValidator.addCertificateChecker(new CertificateAttributesChecker());
        certificatePathValidator.addCertificateChecker(new CertificateICCSNChecker());
        certificatePathValidator.setUseOCSP(ArgTools.getBoolStrict((IArgs)args, (String)ARG_CHECK_OCSP, (boolean)true));
        certificatePathValidator.setUseCRL(ArgTools.getBoolStrict((IArgs)args, (String)ARG_CHECK_CRL, (boolean)true));
        context.setCertificatePathValidator(certificatePathValidator);
        CommonPKIOCSPService ocspService = new CommonPKIOCSPService();
        CommonPKIOCSPTools.configureOCSPService(ocspService, args);
        context.setOCSPService(ocspService);
        CommonPKICRLService crlService = new CommonPKICRLService();
        context.setCRLService(crlService);
        CommonPKITimestampValidator timestampValidator = new CommonPKITimestampValidator();
        context.setTimestampValidator(timestampValidator);
        return context;
    }

    protected synchronized IArgs getDefaultArgs() {
        if (this.defaultArgs == null) {
            this.defaultArgs = Args.create();
            this.defaultArgs.put(ARG_FORCE_VALIDATION, (Object)EnumForceValidationLevel.FULL);
            this.defaultArgs.put(ARG_VALIDATE_CERTIFICATES, (Object)true);
            this.defaultArgs.put(ARG_VALIDATE_TIMESTAMPS, (Object)true);
            this.defaultArgs.put(ARG_ACCEPT_INTERMEDIATE_TRUSTANCHOR, (Object)true);
            this.defaultArgs.put(ARG_STOP_ON_INTERMEDIATE_TRUSTANCHOR, (Object)false);
            this.defaultArgs.put(ARG_CHECK_OCSP, (Object)true);
            this.defaultArgs.put(ARG_CHECK_CRL, (Object)true);
        }
        return this.defaultArgs;
    }
}

