/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.app.validation.common.CommonValidationDataCollector;
import de.intarsys.security.app.validation.common.PACKAGE;
import de.intarsys.security.app.validation.common.ValidationStateWalker;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.standard.validation.ExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCRLRequest;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSOCSPRequest;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryStateValidationDataCollector
extends CommonValidationDataCollector {
    private static final Logger Log = LoggerFactory.getLogger(EntryStateValidationDataCollector.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final IValidationState state;
    private int timestampContext = 0;
    private final Set<IX509CRL> crls = new HashSet<IX509CRL>();
    private final Set<IOCSPResponse> ocsps = new HashSet<IOCSPResponse>();
    private final Set<IX509PublicKeyCertificate> certificates = new HashSet<IX509PublicKeyCertificate>();

    public EntryStateValidationDataCollector(IValidationState state) {
        this.state = state;
    }

    @Override
    public IExtendedValidationData collect() throws IOException {
        this.collect(this.getState());
        return this.createExtendedValidationData();
    }

    protected void collect(IValidationState state) {
        ValidationStateWalker walker = new ValidationStateWalker(){

            @Override
            protected void basicVisit(IVSCertificate state) {
                IX509Certificate certificate;
                if (!EntryStateValidationDataCollector.this.isActive()) {
                    return;
                }
                if (state.getValidationTarget() != null && (certificate = (IX509Certificate)state.getValidationTarget().getImpl()) instanceof IX509PublicKeyCertificate) {
                    EntryStateValidationDataCollector.this.getCertificates().add((IX509PublicKeyCertificate)certificate);
                }
                if (state.isUndefined()) {
                    Log.warn("No validation information for {} available.", (Object)this.getCertificateLabel(state));
                }
                IVSOCSP ocspState = state.getOCSPState();
                IVSCRL crlState = state.getCRLState();
                if ((ocspState == null || ocspState.isUndefined()) && (crlState == null || crlState.isUndefined()) && this.needsRevocationCheck(state.getX509Certificate())) {
                    Log.warn("No revocation information for {} available.", (Object)this.getCertificateLabel(state));
                }
                super.basicVisit(state);
            }

            protected String getCertificateLabel(IVSCertificate state) {
                String unknown = "<unknown>";
                if (state == null) {
                    return unknown;
                }
                IX509Certificate certificate = state.getX509Certificate();
                if (certificate == null) {
                    return unknown;
                }
                return CertificateTools.getSubjectLabel(certificate);
            }

            protected boolean needsRevocationCheck(IX509Certificate certificate) {
                if (certificate == null) {
                    return false;
                }
                if (CertificateTools.isSelfSigned(certificate)) {
                    return false;
                }
                byte[] nocheck = certificate.getExtensionValue("1.3.6.1.5.5.7.48.1.5");
                return nocheck == null;
            }

            @Override
            public void visit(IVSCertificate state) {
                if (EntryStateValidationDataCollector.this.getValidationDataOptions().isAddRevocationInfoDepthSigner()) {
                    this.basicVisit(state);
                } else {
                    super.visit(state);
                }
            }

            @Override
            public void visit(IVSCertificatePath state) {
                if (!(state.getTrustAnchor() != null || state.getCertPath() != null && CertificateTools.isSelfSigned(state.getCertPath().getRootCertificate()))) {
                    Log.warn("Not validated up to trust anchor.");
                }
                super.visit(state);
            }

            @Override
            public void visit(IVSCRLRequest state) {
                if (!EntryStateValidationDataCollector.this.getValidationDataOptions().isAddRevocationInfoTypeCrl()) {
                    return;
                }
                if (!state.isValid()) {
                    return;
                }
                if (!EntryStateValidationDataCollector.this.isActive()) {
                    return;
                }
                IX509CRL crl = state.getCRL();
                if (crl != null) {
                    EntryStateValidationDataCollector.this.getCrls().add(crl);
                }
                super.visit(state);
            }

            @Override
            public void visit(IVSOCSPRequest state) {
                if (!EntryStateValidationDataCollector.this.getValidationDataOptions().isAddRevocationInfoTypeOcsp()) {
                    return;
                }
                if (!state.isValid()) {
                    return;
                }
                if (!EntryStateValidationDataCollector.this.isActive()) {
                    return;
                }
                IOCSPResponse response = state.getResponse();
                if (response != null) {
                    EntryStateValidationDataCollector.this.getOcsps().add(response);
                }
                super.visit(state);
            }

            @Override
            public void visit(IVSTimestamp state) {
                try {
                    ++EntryStateValidationDataCollector.this.timestampContext;
                    super.visit(state);
                }
                finally {
                    --EntryStateValidationDataCollector.this.timestampContext;
                }
            }
        };
        walker.visit(this.getState());
    }

    protected IExtendedValidationData createExtendedValidationData() {
        Set<IX509CRL> crls = this.getCrls();
        Set<IOCSPResponse> ocsps = this.getOcsps();
        Set<IX509PublicKeyCertificate> certificates = this.getCertificates();
        return new ExtendedValidationData(crls.toArray(new IX509CRL[crls.size()]), ocsps.toArray(new IOCSPResponse[ocsps.size()]), certificates.toArray(new IX509PublicKeyCertificate[certificates.size()]));
    }

    protected Set<IX509PublicKeyCertificate> getCertificates() {
        return this.certificates;
    }

    protected Set<IX509CRL> getCrls() {
        return this.crls;
    }

    protected Set<IOCSPResponse> getOcsps() {
        return this.ocsps;
    }

    public IValidationState getState() {
        return this.state;
    }

    protected boolean isActive() {
        if (this.isCollectSignatureData() && this.timestampContext == 0) {
            return true;
        }
        return this.isCollectTimestampData() && this.timestampContext > 0;
    }
}

