/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.algorithm.common.PACKAGE;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.standard.validation.commonpki.CryptoDates;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.date.DateTools;
import de.intarsys.tools.message.AliasMessage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.validation.CommonValidator;
import de.intarsys.tools.validation.ValidationResult;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;

public class WeakSignatureAlgorithmValidator
extends CommonValidator<SignatureAlgorithm> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private final String role;

    public WeakSignatureAlgorithmValidator() {
        this(null);
    }

    public WeakSignatureAlgorithmValidator(String role) {
        this.role = role;
    }

    protected void basicValidate(ValidationResult result, SignatureAlgorithm target) {
        this.checkEncryptionAlgorithm(result, target);
    }

    protected void checkEncryptionAlgorithm(ValidationResult result, SignatureAlgorithm target) {
        LocalDate expirationDate = this.getExpirationDate(target);
        if (expirationDate == null) {
            return;
        }
        LocalDate now = DateTools.toLocalDate((Date)DateEnvironment.get().now());
        if (!now.isBefore(expirationDate)) {
            IMessage msg = Msg.getMessage("WeakSignatureAlgorithmValidator.WarningWeakSignatureAlgorithm", new Object[]{target.getEncryptionAlgorithm().getName(), target.getKeyBitSize(), DATE_TIME_FORMATTER.format(expirationDate)});
            String code = StringTools.pathAppend((String)this.role, (String)".", (String)"weakSignatureAlgorithm");
            result.addWarning((IMessage)new AliasMessage(code, msg, new Object[0]));
        }
    }

    private LocalDate getExpirationDate(SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm == null) {
            return null;
        }
        EncryptionAlgorithm encryptionAlgorithm = signatureAlgorithm.getEncryptionAlgorithm();
        if (encryptionAlgorithm == EncryptionAlgorithm.ALG_RSA) {
            return CryptoDates.getExpirationForRSAKeySize(signatureAlgorithm.getKeyBitSize());
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.ALG_ECDSA || encryptionAlgorithm == EncryptionAlgorithm.ALG_EC) {
            return CryptoDates.getExpirationForECDSAKeySize(signatureAlgorithm.getKeyBitSize());
        }
        return null;
    }
}

