/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.rfc3161;

import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.rfc3161.MessageImprint;
import de.intarsys.asn1.x509.Extensions;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class TimeStampReq
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public Extensions getExtensions() {
        ASN1ValueHolder ext = this.getValueHolder().getNextTaggedGetChild(2, 0, false);
        return (Extensions)Extensions.FACTORY.create(ext);
    }

    public MessageImprint getMessageImprint() {
        return (MessageImprint)MessageImprint.FACTORY.create(this.getValueHolder().getChild(1));
    }

    public BigInteger getNonce() {
        ASN1ValueHolder value = this.getValueHolder().getNextTyped(2, ASN1Integer.class);
        if (value == null) {
            return null;
        }
        return value.toDERInteger().getValue();
    }

    public String getReqPolicy() {
        ASN1ValueHolder value = this.getValueHolder().getNextTyped(2, ASN1ObjectIdentifier.class);
        if (value == null) {
            return null;
        }
        return value.toDERObjectIdentifier().getId();
    }

    public Version getVersion() {
        return (Version)Version.FACTORY.create(this.getValueHolder().getChild(0));
    }

    @Override
    protected void initializeAfterCreateNew() {
        this.setVersion(Version.create(1));
    }

    public boolean isCertReq() {
        ASN1ValueHolder value = this.getValueHolder().getNextTyped(2, ASN1Boolean.class);
        if (value == null) {
            return false;
        }
        return value.toDERBoolean().isTrue();
    }

    private boolean isCertReqExistent() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(2, ASN1Boolean.class);
        return o != null;
    }

    private boolean isNonceExistent() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(2, ASN1Integer.class);
        return o != null;
    }

    private boolean isReqPolicyExistent() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(2, ASN1ObjectIdentifier.class);
        return o != null;
    }

    public void setCertReq(boolean certReq) {
        int index = 2;
        if (this.isReqPolicyExistent()) {
            ++index;
        }
        if (this.isNonceExistent()) {
            ++index;
        }
        if (this.isCertReqExistent()) {
            this.getValueHolder().setChild(index, (ASN1Encodable)ASN1Boolean.getInstance((boolean)certReq));
        } else {
            this.getValueHolder().insertChild(index, (ASN1Encodable)ASN1Boolean.getInstance((boolean)certReq));
        }
    }

    public void setMessageImprint(MessageImprint messageImprint) {
        this.getValueHolder().setChild(1, messageImprint);
    }

    public void setNonce(BigInteger nonce) {
        int index = 2;
        if (this.isReqPolicyExistent()) {
            ++index;
        }
        if (this.isNonceExistent()) {
            this.getValueHolder().setChild(index, (ASN1Encodable)new ASN1Integer(nonce));
        } else {
            this.getValueHolder().insertChild(index, (ASN1Encodable)new ASN1Integer(nonce));
        }
    }

    public void setReqPolicy(String reqPolicy) {
        if (this.isReqPolicyExistent()) {
            this.getValueHolder().setChild(2, (ASN1Encodable)new ASN1ObjectIdentifier(reqPolicy));
        } else {
            this.getValueHolder().insertChild(2, (ASN1Encodable)new ASN1ObjectIdentifier(reqPolicy));
        }
    }

    public void setVersion(Version version) {
        this.getValueHolder().setChild(0, version);
    }

    public static class Factory
    extends ASN1Based.Factory<TimeStampReq> {
    }
}

