/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.policy;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.policy.SignPolicyInfo;
import org.bouncycastle.asn1.DEROctetString;

public class SignaturePolicy
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public AlgorithmIdentifier getSignPolicyHashAlg() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(o);
    }

    public SignPolicyInfo getSignPolicyInfo() {
        ASN1ValueHolder o = this.getValueHolder().getChild(1);
        return (SignPolicyInfo)SignPolicyInfo.FACTORY.create(o);
    }

    public byte[] getSignPolicyHash() {
        if (this.size() < 3) {
            return null;
        }
        DEROctetString hash = this.getValueHolder().getChild(2).toDEROctetString();
        return hash.getOctets();
    }

    public static class Factory
    extends ASN1Based.Factory<SignaturePolicy> {
    }
}

