/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.common;

import de.intarsys.asn1.common.EDIPartyName;
import de.intarsys.asn1.common.OtherName;
import de.intarsys.asn1.model.ASN1Choice;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.x509.Name;
import de.intarsys.asn1.x509.RDNSequence;
import de.intarsys.tools.exception.NotImplementedException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;

public class GeneralName
extends ASN1Choice {
    public static final Factory FACTORY = new Factory();
    public static final int OtherName = 0;
    public static final int Rfc822Name = 1;
    public static final int DNSName = 2;
    public static final int X400Address = 3;
    public static final int DirectoryName = 4;
    public static final int EdiPartyName = 5;
    public static final int UniformResourceIdentifier = 6;
    public static final int IPAddress = 7;
    public static final int RegisteredID = 8;

    public static GeneralName create(Name name) {
        GeneralName result = (GeneralName)FACTORY.createNew();
        result.setDirectoryName(name);
        return result;
    }

    protected String getDERIA5StringDefensive() {
        ASN1Primitive value = this.getValueHolder().getChild().getValue();
        if (value instanceof DERIA5String) {
            return ((DERIA5String)value).getString();
        }
        if (value instanceof ASN1OctetString) {
            return new String(((ASN1OctetString)value).getOctets());
        }
        throw new IllegalArgumentException("Unexpected type: " + value.getClass().getName());
    }

    public Name getDirectoryName() {
        if (this.isDirectoryName()) {
            return (Name)Name.FACTORY.create(this.getValueHolder().getChild());
        }
        return null;
    }

    public String getDNSName() {
        if (this.isDNSName()) {
            return this.getDERIA5StringDefensive();
        }
        return null;
    }

    public EDIPartyName getEDIPartyName() {
        if (this.isEDIPartyName()) {
            return (EDIPartyName)EDIPartyName.FACTORY.create(this.getValueHolder().getChild());
        }
        return null;
    }

    public byte[] getIPAddress() {
        if (this.isIPAddress()) {
            return this.getValueHolder().getChild().toDEROctetString().getOctets();
        }
        return null;
    }

    public OtherName getOtherName() {
        if (this.isOtherName()) {
            return (OtherName)de.intarsys.asn1.common.OtherName.FACTORY.create(this.getValueHolder().getChild());
        }
        return null;
    }

    public String getRegisteredID() {
        if (this.isRegisteredID()) {
            return this.getValueHolder().getChild().toDERObjectIdentifier().getId();
        }
        return null;
    }

    public String getRFC822Name() {
        if (this.isRFC822Name()) {
            return this.getDERIA5StringDefensive();
        }
        return null;
    }

    public String getString() {
        return this.getValueHolder().getChild().toASN1Primitive().toString();
    }

    public String getUniformResourceIdentifier() {
        if (this.isUniformResourceIdentifier()) {
            return this.getDERIA5StringDefensive();
        }
        return null;
    }

    public String getX400Address() {
        if (this.isX400Address()) {
            throw new NotImplementedException();
        }
        return null;
    }

    public boolean isDirectoryName() {
        return this.getTagNo() == 4;
    }

    public boolean isDNSName() {
        return this.getTagNo() == 2;
    }

    public boolean isEDIPartyName() {
        return this.getTagNo() == 5;
    }

    public boolean isIPAddress() {
        return this.getTagNo() == 7;
    }

    public boolean isOtherName() {
        return this.getTagNo() == 0;
    }

    public boolean isRegisteredID() {
        return this.getTagNo() == 8;
    }

    public boolean isRFC822Name() {
        return this.getTagNo() == 1;
    }

    public boolean isUniformResourceIdentifier() {
        return this.getTagNo() == 6;
    }

    public boolean isX400Address() {
        return this.getTagNo() == 3;
    }

    public void setDirectoryName(Name name) {
        this.setDirectoryName(name.getRDNSequence());
    }

    public void setDirectoryName(RDNSequence directoryName) {
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 4, directoryName);
        this.setValueHolder(o);
    }

    public void setDNSName(String dnsName) {
        DERIA5String name = new DERIA5String(dnsName);
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 2, (ASN1Encodable)name);
        this.setValueHolder(o);
    }

    public void setEDIPartyName(EDIPartyName ediPartyName) {
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 5, ediPartyName);
        this.setValueHolder(o);
    }

    public void setIPAddress(byte[] ipAddress) {
        DEROctetString ip = new DEROctetString(ipAddress);
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 7, (ASN1Encodable)ip);
        this.setValueHolder(o);
    }

    public void setOtherName(OtherName otherName) {
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 0, otherName);
        this.setValueHolder(o);
    }

    public void setRegisteredID(String registeredID) {
        ASN1ObjectIdentifier id = new ASN1ObjectIdentifier(registeredID);
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 8, (ASN1Encodable)id);
        this.setValueHolder(o);
    }

    public void setRFC822Name(String rfc822String) {
        DERIA5String name = new DERIA5String(rfc822String);
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 1, (ASN1Encodable)name);
        this.setValueHolder(o);
    }

    public void setUniformResourceIdentifier(String uriString) {
        DERIA5String name = new DERIA5String(uriString);
        ASN1TaggedHolder o = new ASN1TaggedHolder(true, 6, (ASN1Encodable)name);
        this.setValueHolder(o);
    }

    public void setX400Address(Object x400Address) {
    }

    public static class Factory
    extends ASN1Choice.Factory<GeneralName> {
    }
}

