/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.cms.attr.CertifiedAttributesV2;
import de.intarsys.asn1.cms.attr.ClaimedAttributes;
import de.intarsys.asn1.cms.attr.SignedAssertions;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.x509.attr.Attributes;

public class SignerAttributeV2
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public void addClaimedAttributes(Attributes claimedAttributes) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, claimedAttributes);
        this.getValueHolder().addChild(tagged);
    }

    public CertifiedAttributesV2 getCertifiedAttributes() {
        return (CertifiedAttributesV2)CertifiedAttributesV2.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(0, 1, true));
    }

    public ClaimedAttributes getClaimedAttributes() {
        return (ClaimedAttributes)ClaimedAttributes.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(0, 0, true));
    }

    public SignedAssertions getSignedAssertions() {
        return (SignedAssertions)SignedAssertions.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(0, 2, true));
    }

    public boolean hasCertifiedAttributes() {
        return this.getValueHolder().getNextTagged(0, 1) != null;
    }

    public boolean hasClaimedAttributes() {
        return this.getValueHolder().getNextTagged(0, 0) != null;
    }

    public boolean hasSignedAssertions() {
        return this.getValueHolder().getNextTagged(0, 2) != null;
    }

    public void setCertifiedAttributes(CertifiedAttributesV2 certifiedAttributes) {
        int index = 0;
        if (this.hasClaimedAttributes()) {
            ++index;
        }
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 1, certifiedAttributes);
        if (this.hasCertifiedAttributes()) {
            this.getValueHolder().setChild(index, tagged);
        } else {
            this.getValueHolder().insertChild(index, tagged);
        }
    }

    public void setClaimedAttributes(ClaimedAttributes claimedAttributes) {
        int index = 0;
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, claimedAttributes);
        if (this.hasClaimedAttributes()) {
            this.getValueHolder().setChild(index, tagged);
        } else {
            this.getValueHolder().insertChild(index, tagged);
        }
    }

    public void setSignedAssertions(SignedAssertions signedAssertions) {
        int index = 0;
        if (this.hasClaimedAttributes()) {
            ++index;
        }
        if (this.hasCertifiedAttributes()) {
            ++index;
        }
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 2, signedAssertions);
        if (this.hasSignedAssertions()) {
            this.getValueHolder().setChild(index, tagged);
        } else {
            this.getValueHolder().insertChild(index, tagged);
        }
    }

    public static class Factory
    extends ASN1Based.Factory<SignerAttributeV2> {
    }
}

