/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.SignatureValue;
import de.intarsys.asn1.cms.SignedAttributes;
import de.intarsys.asn1.cms.SignerIdentifier;
import de.intarsys.asn1.cms.UnsignedAttributes;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public class SignerInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public SignerInfo copy() throws IOException {
        return (SignerInfo)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(2));
    }

    public SignerIdentifier getSid() {
        return (SignerIdentifier)SignerIdentifier.FACTORY.create(this.getValueHolder().getChild(1));
    }

    public SignatureValue getSignature() {
        int index = 4;
        if (this.hasSignedAttributes()) {
            ++index;
        }
        return (SignatureValue)SignatureValue.FACTORY.create(this.getValueHolder().getChild(index));
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        int index = 3;
        if (this.hasSignedAttributes()) {
            ++index;
        }
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(index));
    }

    public SignedAttributes getSignedAttrs() {
        return (SignedAttributes)SignedAttributes.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(3, 0, false));
    }

    public UnsignedAttributes getUnsignedAttrs() {
        return (UnsignedAttributes)UnsignedAttributes.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(5, 1, false));
    }

    public Version getVersion() {
        return (Version)Version.FACTORY.create(this.getValueHolder().getChild(0));
    }

    protected boolean hasSignedAttributes() {
        return this.getSignedAttrs() != null;
    }

    public void setDigestAlgorithm(AlgorithmIdentifier digestAlgo) {
        this.getValueHolder().setChild(2, digestAlgo);
    }

    public void setSid(SignerIdentifier sid) {
        this.getValueHolder().setChild(1, sid);
    }

    public void setSignature(SignatureValue signature) {
        int index = 4;
        if (this.hasSignedAttributes()) {
            ++index;
        }
        this.getValueHolder().setChild(index, signature);
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier sigAlgId) {
        int index = 3;
        if (this.hasSignedAttributes()) {
            ++index;
        }
        this.getValueHolder().setChild(index, sigAlgId);
    }

    public void setSignedAttrs(SignedAttributes signedAttrs) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(false, 0, signedAttrs);
        if (this.hasSignedAttributes()) {
            this.getValueHolder().setChild(3, tagged);
        } else {
            this.getValueHolder().insertChild(3, tagged);
        }
    }

    public void setUnsignedAttrs(UnsignedAttributes unsignedAttrs) {
        int index = 5;
        if (this.hasSignedAttributes()) {
            ++index;
        }
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(false, 1, unsignedAttrs);
        this.getValueHolder().setChild(index, tagged);
    }

    public void setVersion(Version version) {
        this.getValueHolder().setChild(0, version);
    }

    public void setVersionAccordingToContent() {
        if (this.getSid() == null) {
            throw new IllegalStateException("SignerIdentifier must be set");
        }
        if (this.getSid().isIssuerAndSerialNumber()) {
            this.setVersion(Version.create(1));
        } else if (this.getSid().isSubjectKeyIdentifier()) {
            this.setVersion(Version.create(3));
        } else {
            throw new IllegalStateException("SignerIdentifier is nether issuerAndSerialNumber nor subjectKeyIdentifier");
        }
    }

    public static class Factory
    extends ASN1Based.Factory<SignerInfo> {
    }
}

