/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;

public class OriginatorPublicKey
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public AlgorithmIdentifier getAlgorithm() {
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public byte[] getPublicKey() throws IOException {
        return this.getValueHolder().getChild(1).toDERBitString().getBytes();
    }

    public void setAlgorithm(AlgorithmIdentifier algo) {
        this.getValueHolder().setChild(0, algo);
    }

    public void setPublicKey(byte[] value) {
        this.getValueHolder().setChild(1, (ASN1Encodable)new DERBitString(value));
    }

    public static class Factory
    extends ASN1Based.Factory<OriginatorPublicKey> {
    }
}

