/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.OriginatorIdentifierOrKey;
import de.intarsys.asn1.cms.RecipientEncryptedKeys;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.reflect.ObjectCreationException;

public class KeyAgreeRecipientInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        ASN1ValueHolder value = this.isUkmExistent() ? this.getValueHolder().getChild(3) : this.getValueHolder().getChild(2);
        return (KeyEncryptionAlgorithmIdentifier)KeyEncryptionAlgorithmIdentifier.FACTORY.create(value);
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return (OriginatorIdentifierOrKey)OriginatorIdentifierOrKey.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(1, 0, true));
    }

    public RecipientEncryptedKeys getRecipientEncryptedKeys() {
        ASN1ValueHolder value = this.isUkmExistent() ? this.getValueHolder().getChild(4) : this.getValueHolder().getChild(3);
        return (RecipientEncryptedKeys)RecipientEncryptedKeys.FACTORY.create(value);
    }

    public ASN1ValueHolder getUkm() {
        return this.getValueHolder().getNextTagged(2, 1);
    }

    public Version getVersion() {
        return (Version)Version.FACTORY.create(this.getValueHolder().getChild(0));
    }

    protected boolean isUkmExistent() {
        return this.getUkm() != null;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm) {
        if (this.isUkmExistent()) {
            this.getValueHolder().setChild(3, keyEncryptionAlgorithm);
        } else {
            this.getValueHolder().setChild(2, keyEncryptionAlgorithm);
        }
    }

    public void setOriginator(OriginatorIdentifierOrKey originator) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, originator);
        this.getValueHolder().setChild(1, tagged);
    }

    public void setRecipientEncryptedKeys(RecipientEncryptedKeys recipientEncryptedKeys) {
        if (this.isUkmExistent()) {
            this.getValueHolder().setChild(4, recipientEncryptedKeys);
        } else {
            this.getValueHolder().setChild(3, recipientEncryptedKeys);
        }
    }

    public void setUkm(ASN1ValueHolder ukm) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 1, ukm);
        if (this.isUkmExistent()) {
            this.getValueHolder().setChild(2, tagged);
        } else {
            this.getValueHolder().insertChild(2, tagged);
        }
    }

    public void setVersion(Version version) {
        this.getValueHolder().setChild(0, version);
    }

    public static class Factory
    extends ASN1Based.Factory<KeyAgreeRecipientInfo> {
        @Override
        protected KeyAgreeRecipientInfo basicCreateNew() throws ObjectCreationException {
            KeyAgreeRecipientInfo result = (KeyAgreeRecipientInfo)super.basicCreateNew();
            result.setVersion(Version.create(3));
            return result;
        }
    }
}

