/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.cms.SignerIdentifier;
import de.intarsys.asn1.common.SubjectKeyIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SetHolder;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.asn1.x509.CommonCertificate;
import de.intarsys.asn1.x509.UnknownCertificate;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.util.Iterable;

public class CertificateSet
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public void add(CommonCertificate cert) {
        this.getValueHolder().addChild(cert);
    }

    public void addAll(List<? extends CommonCertificate> certificates) {
        for (CommonCertificate commonCertificate : certificates) {
            this.add(commonCertificate);
        }
    }

    protected CommonCertificate basicGet(int index) {
        ASN1ValueHolder o = this.getValueHolder().getChild(index);
        if (o != null && o.isTagged()) {
            ASN1TaggedHolder to = (ASN1TaggedHolder)o;
            to.setExplicit(false);
            switch (to.getTagNo()) {
                case 0: {
                    return (CommonCertificate)UnknownCertificate.FACTORY.create(to.getChild());
                }
                case 1: {
                    return (CommonCertificate)AttributeCertificate.FACTORY.create(to.getChild());
                }
                case 2: {
                    return (CommonCertificate)AttributeCertificate.FACTORY.create(to.getChild());
                }
                case 3: {
                    return (CommonCertificate)UnknownCertificate.FACTORY.create(to.getChild());
                }
            }
            return (CommonCertificate)UnknownCertificate.FACTORY.create(to.getChild());
        }
        return (CommonCertificate)Certificate.FACTORY.create(o);
    }

    public CertificateSet copy() throws IOException {
        return (CertificateSet)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public Certificate get(int index) {
        CommonCertificate cert = this.basicGet(index);
        if (cert != null && cert.isKeyCertificate()) {
            return (Certificate)cert;
        }
        return null;
    }

    public List<Certificate> getAll() {
        if (this.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<Certificate> result = new ArrayList<Certificate>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Certificate cert = this.get(i);
            if (cert == null) continue;
            result.add(cert);
        }
        return result;
    }

    public List<Certificate> getAllExcept(SignerIdentifier signerID) {
        List<Certificate> all = this.getAll();
        Certificate signerCert = this.getCertificate(signerID);
        all.remove(signerCert);
        return all;
    }

    public Certificate getCertificate(IssuerAndSerialNumber issuerAndSerial) {
        for (int i = 0; i < this.size(); ++i) {
            Certificate cert = this.get(i);
            if (cert == null || !cert.matches(issuerAndSerial)) continue;
            return cert;
        }
        return null;
    }

    public Certificate getCertificate(SignerIdentifier sid) {
        if (sid.getIssuerAndSerialNumber() != null) {
            return this.getCertificate(sid.getIssuerAndSerialNumber());
        }
        if (sid.getSubjectKeyIdentifier() != null) {
            return this.getCertificate(sid.getSubjectKeyIdentifier());
        }
        return null;
    }

    public Certificate getCertificate(SubjectKeyIdentifier subjectKeyIdentifier) {
        for (int i = 0; i < this.size(); ++i) {
            Certificate cert = this.get(i);
            if (cert == null || !cert.matches(subjectKeyIdentifier)) continue;
            return cert;
        }
        return null;
    }

    public boolean isTypeAttributeCertificateV1Present() {
        return this.getValueHolder().getNextTagged(0, 1) != null;
    }

    public boolean isTypeAttributeCertificateV2Present() {
        return this.getValueHolder().getNextTagged(0, 2) != null;
    }

    public boolean isTypeOtherPresent() {
        return this.getValueHolder().getNextTagged(0, 3) != null;
    }

    @Override
    public int size() {
        return this.getValueHolder().size();
    }

    public static class Factory
    extends ASN1Based.Factory<CertificateSet> {
        @Override
        protected CertificateSet basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            ASN1Encodable innerFirst;
            ASN1Primitive obj;
            Iterator itInner;
            ASN1Encodable first;
            Iterator it;
            ASN1Primitive p = asn1.toASN1Primitive();
            if (p instanceof Iterable && (it = ((Iterable)p).iterator()).hasNext() && (first = (ASN1Encodable)it.next()) instanceof Iterable && (itInner = ((Iterable)p).iterator()).hasNext() && ((obj = (innerFirst = (ASN1Encodable)itInner.next()).toASN1Primitive()) instanceof ASN1TaggedObject || obj instanceof ASN1Integer)) {
                return (CertificateSet)super.basicCreate(ASN1SetHolder.with(asn1));
            }
            return (CertificateSet)super.basicCreate(asn1);
        }

        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1SetHolder();
        }
    }
}

