/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cmp;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public Certificate[] getCaPubs() {
        ASN1TaggedHolder value = this.getValueHolder().getNextTagged(0, 1);
        if (value == null) {
            return new Certificate[0];
        }
        ((ASN1ValueHolder)value).setExplicit(true);
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)((ASN1ValueHolder)value).getChild());
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        for (int i = 0; i < sequence.size(); ++i) {
            ASN1Sequence asn1Certificate = ASN1Sequence.getInstance((Object)sequence.getObjectAt(i));
            Certificate certificate = (Certificate)Certificate.FACTORY.create((ASN1Encodable)asn1Certificate);
            certificates.add(certificate);
        }
        return certificates.toArray(new Certificate[certificates.size()]);
    }

    public CertResponse[] getResponse() {
        ASN1ValueHolder value = this.getValueHolder().getNextNotTagged(0);
        if (value == null) {
            return new CertResponse[0];
        }
        ASN1Sequence sequence = (ASN1Sequence)value.getValue();
        ArrayList<CertResponse> responses = new ArrayList<CertResponse>();
        for (int i = 0; i < sequence.size(); ++i) {
            CertResponse certResponse = CertResponse.getInstance((Object)sequence.getObjectAt(i));
            responses.add(certResponse);
        }
        return responses.toArray(new CertResponse[responses.size()]);
    }

    public static class Factory
    extends ASN1Based.Factory<CertRepMessage> {
    }
}

