/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.validation;

import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.UnsignedAttributes;
import de.intarsys.asn1.cms.attr.AttributeCertificateValues;
import de.intarsys.asn1.cms.attr.AttributeRevocationValues;
import de.intarsys.asn1.cms.attr.CertificateValues;
import de.intarsys.asn1.cms.attr.RevocationValues;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.app.signature.CommonValidationDataExtender;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.method.cms.attribute.decoder.CertificateValuesDecoder;
import de.intarsys.security.method.cms.attribute.decoder.RevocationValuesDecoder;
import de.intarsys.security.method.cms.signature.CMSSignatureEntry;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.signature.attribute.ICertificateValuesAttribute;
import de.intarsys.security.signature.attribute.IRevocationValuesAttribute;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;

public class CMSValidationDataExtenderAttributeBased
extends CommonValidationDataExtender<CMSSignatureEntry> {
    protected Supplier<CertificateValues> createCertificateValuesSupplier(final CMSSignatureEntry entry, final HashSet<IX509PublicKeyCertificate> existingCertificates) {
        return new Supplier(){
            private CertificateValues certificateValues;

            public Object get() {
                if (this.certificateValues == null) {
                    try {
                        AttributeCertificateValues attrCertValues = (AttributeCertificateValues)CMSValidationDataExtenderAttributeBased.this.createUnsignedAttribute(entry, AttributeCertificateValues.FACTORY);
                        ICertificateValuesAttribute decodedAttribute = new CertificateValuesDecoder().decodeAttribute(attrCertValues);
                        if (decodedAttribute != null) {
                            existingCertificates.addAll(Arrays.asList(decodedAttribute.getCertificateValues()));
                        }
                        this.certificateValues = attrCertValues.getCertificateValues();
                        if (this.certificateValues == null) {
                            this.certificateValues = (CertificateValues)CertificateValues.FACTORY.createNew();
                            attrCertValues.addAttrValue((ASN1Encodable)this.certificateValues);
                        }
                    }
                    catch (Exception e) {
                        throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
                    }
                }
                return this.certificateValues;
            }
        };
    }

    protected Supplier<RevocationValues> createRevocationValuesSupplier(final CMSSignatureEntry entry, final HashSet<IX509CRL> existingCRLs, final HashSet<IOCSPResponse> existingOCSPs) {
        return new Supplier(){
            private RevocationValues revocValues;

            public Object get() {
                if (this.revocValues == null) {
                    try {
                        AttributeRevocationValues attrRevocValues = (AttributeRevocationValues)CMSValidationDataExtenderAttributeBased.this.createUnsignedAttribute(entry, AttributeRevocationValues.FACTORY);
                        IRevocationValuesAttribute decodedAttribute = new RevocationValuesDecoder().decodeAttribute(attrRevocValues);
                        existingCRLs.addAll(Arrays.asList(decodedAttribute.getCRLs()));
                        existingOCSPs.addAll(Arrays.asList(decodedAttribute.getOCSPs()));
                        this.revocValues = attrRevocValues.getRevocationValues();
                        if (this.revocValues == null) {
                            this.revocValues = (RevocationValues)RevocationValues.FACTORY.createNew();
                            attrRevocValues.addAttrValue((ASN1Encodable)this.revocValues);
                        }
                    }
                    catch (Exception e) {
                        throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
                    }
                }
                return this.revocValues;
            }
        };
    }

    protected <T extends Attribute> T createUnsignedAttribute(CMSSignatureEntry entry, Attribute.Factory<T> factory) {
        Attribute attribute;
        SignerInfo signerInfo = entry.getSignerInfo();
        UnsignedAttributes unsignedAttrs = signerInfo.getUnsignedAttrs();
        if (unsignedAttrs == null) {
            unsignedAttrs = (UnsignedAttributes)UnsignedAttributes.FACTORY.createNew();
            signerInfo.setUnsignedAttrs(unsignedAttrs);
        }
        if ((attribute = unsignedAttrs.get(factory.getAttributeType())) == null) {
            attribute = (Attribute)factory.createNew();
            unsignedAttrs.add(attribute);
        }
        return (T)((Attribute)factory.create((ASN1Encodable)attribute));
    }

    protected void extend(CMSSignatureEntry entry, IExtendedValidationData validationData) throws IOException {
        try {
            this.extendRevocationValues(entry, validationData);
            this.extendCertificateValues(entry, validationData);
        }
        catch (Exception e) {
            throw (IOException)ExceptionTools.unwrapTypedFromChain((Throwable)e, IOException.class);
        }
    }

    protected void extendCertificateValues(CMSSignatureEntry entry, IExtendedValidationData validationData) throws IOException {
        HashSet<IX509PublicKeyCertificate> existingCertificates = new HashSet<IX509PublicKeyCertificate>();
        Supplier<CertificateValues> supplier = this.createCertificateValuesSupplier(entry, existingCertificates);
        validationData.getCertificates().forEach(certificate -> {
            try {
                if (!existingCertificates.contains(certificate)) {
                    ASN1Primitive asn1Certificate = ASN1Tools.create((byte[])certificate.getEncoded());
                    ((CertificateValues)supplier.get()).add((ASN1Encodable)asn1Certificate);
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
            }
        });
    }

    protected void extendRevocationValues(CMSSignatureEntry entry, IExtendedValidationData validationData) throws IOException {
        HashSet<IX509CRL> existingCRLs = new HashSet<IX509CRL>();
        HashSet<IOCSPResponse> existingOCSPs = new HashSet<IOCSPResponse>();
        Supplier<RevocationValues> supplier = this.createRevocationValuesSupplier(entry, existingCRLs, existingOCSPs);
        validationData.getCRLs().forEach(crl -> {
            try {
                if (!existingCRLs.contains(crl)) {
                    ASN1Primitive asn1Crl = ASN1Tools.create((byte[])crl.getEncoded());
                    ((RevocationValues)supplier.get()).addCRL((ASN1Encodable)asn1Crl);
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
            }
        });
        validationData.getOCSPResponses().forEach(ocsp -> {
            try {
                if (!existingOCSPs.contains(ocsp)) {
                    ASN1Primitive asn1Ocsp = ASN1Tools.create((byte[])ocsp.getEncoded());
                    ((RevocationValues)supplier.get()).addOCSP((ASN1Encodable)asn1Ocsp);
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
            }
        });
    }
}

