/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.encryption;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.ContentEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.cms.EncryptedContent;
import de.intarsys.asn1.cms.EncryptedContentInfo;
import de.intarsys.asn1.cms.EnvelopedData;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.cms.RecipientInfos;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.app.crypt.IKeyEncryptedData;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricCryptHandlerRegistry;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricEncryptorException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.encryption.CommonPKCS7Encoder;
import de.intarsys.security.method.cms.encryption.CommonPKCS7RecipientInfoEncoder;
import de.intarsys.security.method.cms.encryption.EncryptorException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class PKCS7EnvelopedDataEncoder
extends CommonPKCS7Encoder {
    private List<IX509PublicKeyCertificate> recipients;
    private ASN1ObjectIdentifier contentType;
    private ISymmetricCryptHandler dataEncryptor;
    private SecretKey contentEncryptionKey;
    private IArgs cekEncryptorArgs;

    public static RecipientInfo encodeRecipient(byte[] key, IX509PublicKeyCertificate certificate, IArgs cekEncryptorArgs) throws EncryptorException {
        CommonPKCS7RecipientInfoEncoder recipientInfoEncoder = CommonPKCS7RecipientInfoEncoder.create(certificate);
        return recipientInfoEncoder.encode(key, certificate, cekEncryptorArgs);
    }

    public IArgs getCekEncryptorArgs() {
        if (this.cekEncryptorArgs == null) {
            this.cekEncryptorArgs = Args.create();
        }
        return this.cekEncryptorArgs;
    }

    public SecretKey getContentEncryptionKey() {
        return this.contentEncryptionKey;
    }

    public ASN1ObjectIdentifier getContentType() {
        if (this.contentType == null) {
            this.contentType = CMSObjectIdentifiers.data;
        }
        return this.contentType;
    }

    public ISymmetricCryptHandler getDataEncryptor() {
        if (this.dataEncryptor == null) {
            this.dataEncryptor = SymmetricCryptHandlerRegistry.get().lookupHandler("2.16.840.1.101.3.4.1.2");
        }
        return this.dataEncryptor;
    }

    public List<IX509PublicKeyCertificate> getRecipients() {
        if (this.recipients == null) {
            this.recipients = Collections.EMPTY_LIST;
        }
        return this.recipients;
    }

    @Override
    public CMS process(ILocator source) throws EncryptorException {
        IKeyEncryptedData encryptedData = null;
        try {
            byte[] data = LocatorTools.getBytes((ILocator)source);
            SecretKey contentEncryptionKey = this.getContentEncryptionKey();
            if (contentEncryptionKey == null) {
                contentEncryptionKey = this.getDataEncryptor().generateKey();
            }
            encryptedData = this.getDataEncryptor().encrypt(data, contentEncryptionKey);
        }
        catch (SymmetricEncryptorException e) {
            throw new EncryptorException(e);
        }
        catch (IOException e) {
            throw new EncryptorException(e);
        }
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)EncryptedContentInfo.FACTORY.createNew();
        encryptedContentInfo.setContentType((ContentType)ContentType.FACTORY.create((ASN1Encodable)this.getContentType()));
        ContentEncryptionAlgorithmIdentifier algIdentifier = ContentEncryptionAlgorithmIdentifier.create((String)encryptedData.getAlgorithmOID());
        if (encryptedData.getAlgorithmParameters() != null) {
            try {
                algIdentifier.setParameters((ASN1Encodable)ASN1Tools.create((byte[])encryptedData.getAlgorithmParameters()));
            }
            catch (IOException e) {
                throw new EncryptorException(e);
            }
        }
        encryptedContentInfo.setContentEncryptionAlgorithmIdentifier(algIdentifier);
        try {
            byte[] bytes = LocatorTools.getBytes((ILocator)encryptedData.getLocator());
            encryptedContentInfo.setEncryptedContent(EncryptedContent.create((byte[])bytes));
        }
        catch (IOException e) {
            throw new EncryptorException(e);
        }
        CMS cms = (CMS)CMS.FACTORY.createNew();
        EnvelopedData data = (EnvelopedData)EnvelopedData.FACTORY.createNew();
        data.setEncryptedContentInfo(encryptedContentInfo);
        RecipientInfos recipientInfos = (RecipientInfos)RecipientInfos.FACTORY.createNew();
        for (IX509PublicKeyCertificate certificate : this.getRecipients()) {
            RecipientInfo recipientInfo = PKCS7EnvelopedDataEncoder.encodeRecipient(encryptedData.getKey(), certificate, this.getCekEncryptorArgs());
            recipientInfos.add(recipientInfo);
        }
        data.setRecipientInfos(recipientInfos);
        data.setVersion(Version.create((int)0));
        cms.setEnvelopedData(data);
        return cms;
    }

    public void setCekEncryptorArgs(IArgs cekEncryptorArgs) {
        this.cekEncryptorArgs = cekEncryptorArgs;
    }

    public void setContentEncryptionKey(SecretKey contentEncryptionKey) {
        this.contentEncryptionKey = contentEncryptionKey;
    }

    public void setContentType(ASN1ObjectIdentifier contentType) {
        this.contentType = contentType;
    }

    public void setDataEncryptor(ISymmetricCryptHandler dataEncryptor) {
        this.dataEncryptor = dataEncryptor;
    }

    public void setRecipients(List<IX509PublicKeyCertificate> certificates) {
        this.recipients = certificates;
    }
}

