/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.encryption;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.method.cms.encryption.EncryptorException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;

public abstract class CommonPKCS7Encoder {
    protected CommonPKCS7Encoder() {
    }

    public void close() throws SecurityApplicationException {
    }

    public void encrypt(ILocator source, ILocator destination) throws EncryptorException {
        OutputStream os = null;
        try {
            CMS cms = this.process(source);
            os = destination.getOutputStream();
            ASN1Tools.writeOn((OutputStream)os, (ASN1Encodable[])new ASN1Encodable[]{cms});
        }
        catch (IOException e) {
            try {
                throw new EncryptorException(e);
            }
            catch (Throwable throwable) {
                StreamTools.close(os);
                throw throwable;
            }
        }
        StreamTools.close((Closeable)os);
    }

    public void open() throws SecurityApplicationException {
    }

    public abstract CMS process(ILocator var1) throws EncryptorException;
}

