/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.attr.AttributeRevocationInfoArchival;
import de.intarsys.asn1.cms.attr.RevocationInfoArchival;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.method.cms.attribute.encoder.CommonRevocationInfoEncoder;
import de.intarsys.security.method.cms.attribute.encoder.PACKAGE;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPTools;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.OCSPResponse;

public class RevocationInfoArchivalEncoder
extends CommonRevocationInfoEncoder {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.1");

    @Override
    protected Attribute createAttribute(IExtendedValidationData validationData) throws IOException {
        try {
            AttributeRevocationInfoArchival result = (AttributeRevocationInfoArchival)AttributeRevocationInfoArchival.FACTORY.createNew();
            RevocationInfoArchival revocationInfoArchival = (RevocationInfoArchival)RevocationInfoArchival.FACTORY.createNew();
            validationData.getCRLs().forEach(crl -> {
                try {
                    ASN1Primitive asn1Crl = ASN1Tools.create((byte[])crl.getEncoded());
                    revocationInfoArchival.addCRL((ASN1Encodable)asn1Crl);
                }
                catch (Exception e) {
                    String msg = Msg.getString("AttributeRevocationInfoArchivalProvider.ErrorParsingOCSPResponse", new Object[0]);
                    throw ExceptionTools.wrap((Throwable)new IOException(msg, e));
                }
            });
            validationData.getOCSPResponses().forEach(ocsp -> {
                try {
                    OCSPResponse ocspResponse = OCSPTools.asAsn1OcspResponse((IOCSPResponse)ocsp);
                    revocationInfoArchival.addOCSP((ASN1Encodable)ocspResponse);
                }
                catch (IOException e) {
                    String msg = Msg.getString("AttributeRevocationInfoArchivalProvider.ErrorParsingOCSPResponse", new Object[0]);
                    throw ExceptionTools.wrap((Throwable)new IOException(msg, e));
                }
            });
            result.setRevocationInfoArchival(revocationInfoArchival);
            return result;
        }
        catch (Exception e) {
            throw (IOException)ExceptionTools.unwrapTypedFromChain((Throwable)e, IOException.class);
        }
    }

    @Override
    public boolean isToBeSigned() {
        return true;
    }
}

