/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.attr.AttributeCommitmentType;
import de.intarsys.asn1.cms.attr.CommitmentTypeIndication;
import de.intarsys.asn1.cms.attr.CommitmentTypeQualifier;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.policy.ICommitmentTypeIndication;
import de.intarsys.security.signature.policy.IQualifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CommitmentTypeIndicationEncoder
implements IAttributeEncoder {
    private List<ICommitmentTypeIndication> commitmentTypeIndications;

    public CommitmentTypeIndicationEncoder(List<ICommitmentTypeIndication> commitmentTypeIndications) {
        this.commitmentTypeIndications = commitmentTypeIndications;
    }

    protected CommitmentTypeIndication createCommitmentTypeIndication(ICommitmentTypeIndication commitmentTypeIndication) {
        CommitmentTypeIndication asn1CommitmentTypeIndication = (CommitmentTypeIndication)CommitmentTypeIndication.FACTORY.createNew();
        asn1CommitmentTypeIndication.setCommitmentTypeId(commitmentTypeIndication.getOID());
        for (IQualifier qualifier : commitmentTypeIndication.getQualifiers()) {
            CommitmentTypeQualifier commitmentTypeQualifier = (CommitmentTypeQualifier)CommitmentTypeQualifier.FACTORY.createNew();
            commitmentTypeQualifier.setCommitmentTypeIdentifier(qualifier.getOID());
            commitmentTypeQualifier.setQualifier(null);
            asn1CommitmentTypeIndication.addCommitmentTypeQualifier(commitmentTypeQualifier);
        }
        return asn1CommitmentTypeIndication;
    }

    @Override
    public Attribute getAttribute(ICMSSignatureContainerBuilder builder, CMS cms, SignerInfo signerInfo, ISignatureData signatureData) throws IOException {
        AttributeCommitmentType commitmentType = (AttributeCommitmentType)AttributeCommitmentType.FACTORY.createNew();
        for (ICommitmentTypeIndication commitmentTypeIndication : this.getCommitmentTypeIndications()) {
            commitmentType.addCommitmentTypeIndication(this.createCommitmentTypeIndication(commitmentTypeIndication));
        }
        return commitmentType;
    }

    public List<ICommitmentTypeIndication> getCommitmentTypeIndications() {
        return new ArrayList<ICommitmentTypeIndication>(this.commitmentTypeIndications);
    }

    @Override
    public boolean isToBeSigned() {
        return true;
    }
}

