/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.composite.JsonFactoryAware;
import net.logstash.logback.composite.JsonReadingUtils;

public class GlobalCustomFieldsJsonProvider<Event extends DeferredProcessingAware>
extends AbstractJsonProvider<Event>
implements JsonFactoryAware {
    private String customFields;
    private ObjectNode customFieldsNode;
    private JsonFactory jsonFactory;

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        this.writeFieldsOfNode(generator, (JsonNode)this.customFieldsNode);
    }

    private void writeFieldsOfNode(JsonGenerator generator, JsonNode node) throws IOException {
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                generator.writeFieldName((String)field.getKey());
                generator.writeTree((TreeNode)field.getValue());
            }
        }
    }

    @Override
    public void start() {
        this.initializeCustomFields();
        super.start();
    }

    private void initializeCustomFields() {
        if (this.customFieldsNode != null || this.customFields == null) {
            return;
        }
        if (this.jsonFactory == null) {
            throw new IllegalStateException("JsonFactory has not been set");
        }
        try {
            this.customFieldsNode = JsonReadingUtils.readFullyAsObjectNode(this.jsonFactory, this.customFields);
        }
        catch (IOException e) {
            this.addError("[customFields] is not a valid JSON object", e);
        }
    }

    public void setCustomFields(String customFields) {
        if (this.isStarted()) {
            throw new IllegalStateException("Configuration cannot be changed while the provider is started");
        }
        this.customFields = customFields;
        this.customFieldsNode = null;
    }

    public String getCustomFields() {
        return this.customFields;
    }

    public ObjectNode getCustomFieldsNode() {
        return this.customFieldsNode;
    }

    @Deprecated
    public void setCustomFieldsNode(JsonNode customFields) {
        if (customFields != null && !(customFields instanceof ObjectNode)) {
            throw new IllegalArgumentException("Must be an ObjectNode");
        }
        this.setCustomFieldsNode((ObjectNode)customFields);
    }

    public void setCustomFieldsNode(ObjectNode customFields) {
        if (this.isStarted()) {
            throw new IllegalStateException("Configuration cannot be changed while the provider is started");
        }
        this.customFieldsNode = customFields;
        this.customFields = null;
    }

    @Override
    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = Objects.requireNonNull(jsonFactory);
    }
}

