/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.audit.v2.core;

import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.IAuditSessionKeyCodec;
import de.intarsys.tools.encoding.Base64;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PlainSessionKeyCodec
implements IAuditSessionKeyCodec {
    @Override
    public byte[] createSessionKey(Map params) throws AuditException {
        String type = (String)params.get("type");
        if (!"P".equals(type)) {
            throw new AuditException("unsupported key type");
        }
        String value = (String)params.get("value");
        try {
            return Base64.decode((String)value);
        }
        catch (IOException e) {
            throw new AuditException("key encoding failure", e);
        }
    }

    @Override
    public Map createSessionKeyParams(byte[] value) {
        HashMap<String, String> keyParams = new HashMap<String, String>();
        keyParams.put("type", "P");
        keyParams.put("value", this.encode(value));
        return keyParams;
    }

    protected String encode(byte[] value) {
        return new String(Base64.encode((byte[])value));
    }
}

