/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.audit.v2.core;

import de.intarsys.security.audit.v2.core.AuditEntry;
import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.AuditSession;
import de.intarsys.security.audit.v2.core.CommonProtocol;
import de.intarsys.security.audit.v2.core.IAuditEntry;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.json.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class AuditV2Protocol
extends CommonProtocol {
    public static final char COMMAND_OPEN = 'O';
    public static final char COMMAND_DATA = 'D';
    public static final char COMMAND_HEARTBEAT = 'H';
    public static final char COMMAND_SIGN = 'S';
    public static final char COMMAND_CLOSE = 'C';
    public static final String V_2 = "2.0";
    private static final byte[] separator = new byte[]{59};

    @Override
    public byte[] acceptEntry(AuditSession session, IAuditEntry entry) throws AuditException {
        return this.createSeal(session, entry);
    }

    protected IDigest createDigest(AuditSession session, IAuditEntry entry) throws AuditException {
        try {
            IDigester digest = session.getDigester();
            digest.reset();
            if (session.getPreviousDigest() != null) {
                digest.digestUpdate((InputStream)new ByteArrayInputStream(session.getPreviousDigest().getBytes()));
                digest.digestUpdate((InputStream)new ByteArrayInputStream(this.getSeparator()));
            }
            digest.digestUpdate((InputStream)new ByteArrayInputStream(new byte[]{(byte)entry.getAuditCommand()}));
            digest.digestUpdate((InputStream)new ByteArrayInputStream(this.getSeparator()));
            digest.digestUpdate((InputStream)new ByteArrayInputStream(ByteArrayTools.toBytesLittleEndian((int)entry.getAuditSequenceNumber(), (int)4)));
            digest.digestUpdate((InputStream)new ByteArrayInputStream(this.getSeparator()));
            digest.digestUpdate((InputStream)new ByteArrayInputStream(ByteArrayTools.toBytesLittleEndian((long)entry.getAuditTick(), (int)8)));
            digest.digestUpdate((InputStream)new ByteArrayInputStream(this.getSeparator()));
            digest.digestUpdate((InputStream)new ByteArrayInputStream(entry.getAuditMessage().getBytes(StandardCharsets.UTF_8)));
            return digest.digestFinal();
        }
        catch (IOException e) {
            throw new AuditException(e);
        }
    }

    protected byte[] createSeal(AuditSession session, IAuditEntry entry) throws AuditException {
        IDigest digest = this.createDigest(session, entry);
        session.updateState(entry.getAuditSequenceNumber() + 1, digest);
        return this.createSignature(session, digest);
    }

    protected byte[] createSignature(AuditSession session, IDigest digest) {
        return session.getMac().doFinal(digest.getBytes());
    }

    protected byte[] getSeparator() {
        return separator;
    }

    protected String getVersion() {
        return V_2;
    }

    @Override
    public void handleEntryClose(AuditSession session, AuditEntry entry) throws AuditException {
        entry.setAuditCommand('C');
        this.updateEntry(session, entry);
    }

    @Override
    public void handleEntryHeartbeat(AuditSession session, AuditEntry entry) throws AuditException {
        entry.setAuditCommand('H');
        this.updateEntry(session, entry);
    }

    @Override
    public void handleEntryLog(AuditSession session, AuditEntry entry) throws AuditException {
        entry.setAuditCommand('D');
        this.updateEntry(session, entry);
    }

    @Override
    public void handleEntryOpen(AuditSession session, AuditEntry entry) throws AuditException {
        entry.setAuditCommand('O');
        HashMap<String, Object> cmdParams = new HashMap<String, Object>();
        cmdParams.put("v", this.getVersion());
        cmdParams.put("hash", session.getDigester().getAlgorithmName());
        cmdParams.put("mac", session.getMac().getAlgorithm());
        cmdParams.put("key", session.getSessionKeyParams());
        try {
            entry.setAuditMessage(JsonWriter.toString(cmdParams, (int)1, (int)1));
        }
        catch (IOException e) {
            throw new AuditException(e);
        }
        this.updateEntry(session, entry);
    }

    @Override
    public void handleEntrySign(AuditSession session, AuditEntry entry) throws AuditException {
        try {
            entry.setAuditCommand('S');
            Map<String, Object> signature = session.getAudit().getSignatureProvider().sign(session.getPreviousDigest());
            entry.setAuditMessage(JsonWriter.toString(signature, (int)1, (int)1));
            this.updateEntry(session, entry);
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    protected void updateEntry(AuditSession session, AuditEntry entry) throws AuditException {
        entry.setAuditTick(session.getAudit().getTickProvider().getTick());
        entry.setAuditSequenceNumber(session.getSequenceNumber());
        entry.setAuditSeal(this.createSeal(session, entry));
    }
}

