/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.common;

import de.intarsys.tools.preferences.IScopedPlatformPreferences;
import de.intarsys.tools.preferences.common.ExtendedPreferences;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class ScopedPreferencesImpl
extends ExtendedPreferences
implements IScopedPlatformPreferences {
    private static final int DEFAULT_SIZE = 4;
    private Preferences[] scopes;
    private String[] scopeNames;
    private int count;
    private Preferences defaultScope;
    private Preferences writeScope;

    public ScopedPreferencesImpl(ScopedPreferencesImpl parent, String name) {
        super(parent, name);
        if (parent == null) {
            this.count = 0;
            this.scopes = new Preferences[4];
            this.scopeNames = new String[4];
            this.defaultScope = null;
            this.writeScope = null;
        } else {
            this.count = parent.count;
            this.scopes = parent.scopes;
            this.scopeNames = parent.scopeNames;
            this.defaultScope = parent.defaultScope;
            this.writeScope = parent.writeScope;
        }
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener ncl) {
        if (this.writeScope != null) {
            Preferences prefs = this.writeScope.node(this.absolutePath());
            prefs.addNodeChangeListener(ncl);
        }
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        if (this.writeScope != null) {
            Preferences prefs = this.writeScope.node(this.absolutePath());
            prefs.addPreferenceChangeListener(pcl);
        }
    }

    public void addScope(String name, Preferences preferences) {
        this.addScope(name, preferences, false);
    }

    public void addScope(String name, Preferences preferences, boolean writeable) {
        if (this.count >= this.scopes.length) {
            Preferences[] newScopes = new Preferences[this.count + 2];
            System.arraycopy(this.scopes, 0, newScopes, 0, this.count);
            String[] newNames = new String[this.count + 2];
            System.arraycopy(this.scopeNames, 0, newNames, 0, this.count);
            this.scopes = newScopes;
            this.scopeNames = newNames;
        }
        this.scopes[this.count] = preferences;
        this.scopeNames[this.count] = name;
        ++this.count;
        if (this.defaultScope == null) {
            this.defaultScope = preferences;
        }
        if (writeable) {
            this.writeScope = preferences;
        }
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.count; ++i) {
            Preferences prefs = this.scopes[i].node(this.absolutePath());
            result.addAll(Arrays.asList(prefs.childrenNames()));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        ScopedPreferencesImpl result = new ScopedPreferencesImpl(this, name);
        return result;
    }

    @Override
    public void flush() throws BackingStoreException {
        for (int i = 0; i < this.count; ++i) {
            Preferences prefs = this.scopes[i].node(this.absolutePath());
            prefs.flush();
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    public List getScopeNames() {
        return Arrays.asList(this.scopeNames);
    }

    public List getScopes() {
        return Arrays.asList(this.scopes);
    }

    @Override
    protected String getSpi(String key) {
        for (int i = this.count - 1; i >= 0; --i) {
            Preferences prefs = this.scopes[i].node(this.absolutePath());
            String pref = prefs.get(key, null);
            if (pref == null) continue;
            return pref;
        }
        return null;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        HashSet result = new HashSet();
        BackingStoreException firstException = null;
        for (int i = 0; i < this.count; ++i) {
            Preferences prefs = this.scopes[i].node(this.absolutePath());
            try {
                Collections.addAll(result, prefs.keys());
                continue;
            }
            catch (BackingStoreException ex) {
                if (firstException != null) continue;
                firstException = ex;
            }
        }
        if (result.size() == 0 && firstException != null) {
            throw firstException;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected void putSpi(String key, String value) {
        Preferences writePrefs = this.writeScope.node(this.absolutePath());
        writePrefs.remove(key);
        String pref = this.get(key, null);
        if (pref != null && pref.equals(value)) {
            return;
        }
        writePrefs.put(key, value);
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener ncl) {
        if (this.writeScope != null) {
            Preferences prefs = this.writeScope.node(this.absolutePath());
            prefs.removeNodeChangeListener(ncl);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        if (this.writeScope != null) {
            Preferences prefs = this.writeScope.node(this.absolutePath());
            prefs.removeNode();
        }
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        if (this.writeScope != null) {
            Preferences prefs = this.writeScope.node(this.absolutePath());
            prefs.removePreferenceChangeListener(pcl);
        }
    }

    public void removeScope(String name) {
        int i;
        for (i = 0; i < this.count; ++i) {
            if (!this.scopeNames[i].equals(name)) continue;
            --this.count;
            break;
        }
        while (i < this.count) {
            this.scopeNames[i] = this.scopeNames[i + 1];
            this.scopes[i] = this.scopes[i + 1];
            ++i;
        }
        if (this.count > 0) {
            this.writeScope = this.scopes[this.count - 1];
        } else {
            this.defaultScope = null;
            this.writeScope = null;
        }
    }

    @Override
    protected void removeSpi(String key) {
        Preferences writePrefs = this.writeScope.node(this.absolutePath());
        writePrefs.remove(key);
    }

    public Preferences restrict(String name) {
        ScopedPreferencesImpl result = new ScopedPreferencesImpl((ScopedPreferencesImpl)this.parent(), this.name());
        for (int i = 0; i < this.count; ++i) {
            if (!result.scopeNames[i].equals(name)) continue;
            result.defaultScope = result.scopes[0];
            result.writeScope = result.scopes[i];
            result.count = i + 1;
            return result;
        }
        return result;
    }

    @Override
    public void sync() throws BackingStoreException {
        for (int i = 0; i < this.count; ++i) {
            Preferences prefs = this.scopes[i].node(this.absolutePath());
            prefs.sync();
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

