/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectsession;

import de.intarsys.tools.locking.AbstractLockStrategy;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockStrategy;
import de.intarsys.tools.locking.LockStrategy;
import de.intarsys.tools.objectsession.LockException;
import de.intarsys.tools.objectsession.ObjectEntryFactory;
import de.intarsys.tools.objectsession.ObjectSession;
import de.intarsys.tools.objectsession.ObjectSessionEntry;
import de.intarsys.tools.objectsession.ObjectSessionException;
import de.intarsys.tools.objectsession.ObjectSessionType;
import de.intarsys.tools.transaction.ResourceException;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class EntryBasedObjectSession
extends ObjectSession {
    private ObjectEntryFactory entryFactory = ObjectEntryFactory.theFactory();
    private ILockStrategy lockStrategy = LockStrategy.get();
    private Map<Object, ObjectSessionEntry> objects = new IdentityHashMap<Object, ObjectSessionEntry>();

    protected EntryBasedObjectSession(ObjectSessionType type, ObjectSession parent) {
        super(type, parent);
    }

    @Override
    public void change(Object object) throws ObjectSessionException {
        ObjectSessionEntry entry = this.lookupEntry(object);
        if (entry == null) {
            this.lock(object);
            entry = this.entryFactory.createEntry(object);
            this.registerEntry(entry);
        }
        entry.doChange();
    }

    protected abstract void commitEntry(ObjectSessionEntry var1) throws ResourceException;

    @Override
    public void delete(Object object) throws ObjectSessionException {
        ObjectSessionEntry entry = this.lookupEntry(object);
        if (entry == null) {
            this.lock(object);
            entry = this.entryFactory.createEntry(object);
            this.registerEntry(entry);
        }
        entry.doDelete();
    }

    @Override
    protected void doCommit() throws ResourceException {
        for (Map.Entry<Object, ObjectSessionEntry> entry : this.objects.entrySet()) {
            Object object = entry.getKey();
            ObjectSessionEntry sessionEntry = entry.getValue();
            this.commitEntry(sessionEntry);
            this.unlock(object);
            this.propagateLock(object);
        }
        this.objects.clear();
    }

    @Override
    protected void doRollback() throws ResourceException {
        for (Map.Entry<Object, ObjectSessionEntry> entry : this.objects.entrySet()) {
            Object object = entry.getKey();
            ObjectSessionEntry sessionEntry = entry.getValue();
            this.rollbackEntry(sessionEntry);
            this.unlock(object);
            this.propagateLock(object);
        }
        this.objects.clear();
    }

    @Override
    protected void doRollforward() throws ResourceException {
        for (Map.Entry<Object, ObjectSessionEntry> entry : this.objects.entrySet()) {
            Object object = entry.getKey();
            ObjectSessionEntry sessionEntry = entry.getValue();
            this.rollforwardEntry(sessionEntry);
            this.unlock(object);
            this.propagateLock(object);
        }
    }

    protected ILockStrategy getLockStrategy() {
        return this.lockStrategy;
    }

    public abstract EntryBasedObjectSession getParent();

    @Override
    protected boolean isChanged() {
        return this.objects.size() > 0;
    }

    @Override
    protected boolean isEmptyLocal() {
        return this.objects.size() == 0;
    }

    protected void lock(Object object) throws ObjectSessionException {
        if (!this.getLockStrategy().lock(object, (Object)this, ILockLevel.EXCLUSIVE)) {
            throw new LockException("object already locked");
        }
    }

    protected ObjectSessionEntry lookupEntry(Object object) {
        return this.objects.get(object);
    }

    public void merge(ObjectSessionEntry other) {
        ObjectSessionEntry localEntry = this.lookupEntry(other.getObject());
        if (localEntry == null) {
            this.registerEntry(other);
        } else {
            if (other.getState().isDeleted()) {
                localEntry.setDeleted();
            }
            localEntry.merge(this, other);
        }
    }

    protected void propagateLock(Object object) {
        EntryBasedObjectSession parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (parent.lookupEntry(object) != null) {
            try {
                parent.lock(object);
            }
            catch (ObjectSessionException objectSessionException) {}
        } else {
            parent.propagateLock(object);
        }
    }

    protected void registerEntry(ObjectSessionEntry entry) {
        this.objects.put(entry.getObject(), entry);
    }

    protected abstract void rollbackEntry(ObjectSessionEntry var1) throws ResourceException;

    protected abstract void rollforwardEntry(ObjectSessionEntry var1) throws ResourceException;

    @Override
    public void save(Object object) throws ObjectSessionException {
        ObjectSessionEntry entry = this.lookupEntry(object);
        if (entry == null) {
            this.lock(object);
            entry = this.entryFactory.createEntry(object);
            this.registerEntry(entry);
        }
        entry.doSave();
    }

    public void setLockStrategy(AbstractLockStrategy lockStrategy) {
        this.lockStrategy = lockStrategy;
    }

    protected void unlock(Object object) {
        this.getLockStrategy().unlock(object, (Object)this);
    }
}

