/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jmx;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.jmx.CommonNotificationListener;
import de.intarsys.tools.jmx.CommonNotificationListenerFactory;
import de.intarsys.tools.logging.EnumLogLevel;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import javax.management.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LogNotificationListener
extends CommonNotificationListener {
    private String name = this.getClass().getName();
    private String message = "${notification.type}: ${notification.message}";
    private EnumLogLevel level = EnumLogLevel.INFO;

    public LogNotificationListener() {
    }

    public LogNotificationListener(CommonNotificationListenerFactory factory) {
        super(factory);
    }

    @Override
    protected void basicHandleNotification(Notification notification) {
        String tmpLogger = this.expand(this.getName(), notification);
        String tmpMessage = this.expand(this.getMessage(), notification);
        Logger log = LoggerFactory.getLogger((String)tmpLogger);
        Level slf4jLevel = Slf4jTools.toLevel((EnumLogLevel)this.getLevel(), (Level)Level.ERROR);
        log.atLevel(slf4jLevel).log(tmpMessage);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setName(element.attributeValue("name", this.getName()));
        EnumLogLevel enumLevel = (EnumLogLevel)ElementTools.getEnumItem((IElement)element, (String)"level", (EnumMeta)EnumLogLevel.META, (EnumItem)EnumLogLevel.ERROR);
        this.setLevel(enumLevel);
        this.setMessage(element.attributeValue("message", this.getMessage()));
    }

    public EnumLogLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setAttributeValue("name", this.getName());
        element.setAttributeValue("level", this.getLevel().toString());
        element.setAttributeValue("message", this.getMessage());
    }

    public void setLevel(EnumLogLevel level) {
        this.level = level;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Benachrichtigung im Log";
    }
}

