/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.xfs;

import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.xfs.IXFSNode;
import de.intarsys.tools.xfs.XFSClassLoaderNode;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XFSScanner {
    private String rootPath = "";
    private ClassLoader classLoader;
    private String pattern;

    public XFSScanner() {
        this.setClassLoader(this.getClass().getClassLoader());
    }

    public XFSScanner(ClassLoader classLoader, String rootPath, String pattern) {
        this.classLoader = classLoader;
        this.rootPath = rootPath;
        this.pattern = pattern;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void scan(FoundCallback callback) throws IOException {
        XFSClassLoaderNode node = new XFSClassLoaderNode(this.getClassLoader());
        IXFSNode rootNode = StringTools.isEmpty(this.getRootPath()) ? node : node.getChild(this.getRootPath());
        if (this.getPattern() != null) {
            Pattern tmpPattern = Pattern.compile(this.getPattern());
            Matcher matcher = tmpPattern.matcher("");
            this.scan(callback, rootNode, matcher);
        } else {
            this.scan(callback, rootNode, null);
        }
    }

    protected void scan(FoundCallback callback, IXFSNode rootNode, Matcher matcher) throws IOException {
        if (rootNode == null) {
            return;
        }
        for (IXFSNode child : rootNode.getChildren()) {
            if (matcher == null) {
                callback.onFound(child);
                continue;
            }
            String tmpName = child.getPath() + child.getName();
            matcher.reset(tmpName);
            if (matcher.matches()) {
                callback.onFound(child);
                continue;
            }
            if (!matcher.hitEnd()) continue;
            this.scan(callback, child, matcher);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setRootPath(String root) {
        this.rootPath = root;
    }

    public static interface FoundCallback {
        public void onFound(IXFSNode var1) throws IOException;
    }
}

