/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.system;

import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProperty {
    private static final Logger Log = LoggerFactory.getLogger(SystemProperty.class);
    private String key;
    private String value;
    private String usage;

    public String getKey() {
        return this.key;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getValue() {
        return this.value;
    }

    @PostConstruct
    public void perform() {
        String oldValue = System.getProperty(this.key, null);
        if ("always".equals(this.usage)) {
            System.setProperty(this.key, this.value);
            if (oldValue == null) {
                Log.info("set system property '" + this.key + "' to '" + this.value + "'");
            } else {
                Log.info("change system property '" + this.key + "' from '" + oldValue + "' to '" + this.value + "'");
            }
        } else if ("optional".equals(this.usage)) {
            if (oldValue == null) {
                System.setProperty(this.key, this.value);
                Log.info("set system property '" + this.key + "' to '" + this.value + "'");
            } else {
                Log.info("keep system property '" + this.key + "' as '" + oldValue + "'");
            }
        } else if (!"never".equals(this.usage)) {
            throw new IllegalArgumentException("SystemProperty unknown usage " + this.usage);
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

