/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class CharacterTools {
    public static void clear(char[] value) {
        if (value == null) {
            return;
        }
        Arrays.fill(value, '0');
    }

    public static boolean isEmpty(char[] value) {
        if (value == null || value.length == 0) {
            return true;
        }
        for (int i = 0; i < value.length; ++i) {
            if (Character.isWhitespace(value[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U';
    }

    public static byte[] toByteArray(char[] value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = new byte[value.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)value[i];
        }
        return bytes;
    }

    public static byte[] toByteArray(char[] chars, Charset charset) {
        if (chars == null) {
            return null;
        }
        ByteBuffer bb = charset.encode(CharBuffer.wrap(chars));
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes, 0, bytes.length);
        return bytes;
    }

    public static byte[] toByteArrayUTF8(char[] chars) {
        Charset charset = StandardCharsets.UTF_8;
        return CharacterTools.toByteArray(chars, charset);
    }

    public static char[] toCharArray(byte[] value) {
        if (value == null) {
            return null;
        }
        char[] chars = new char[value.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)value[i];
        }
        return chars;
    }

    public static char[] toCharArray(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(bytes));
        char[] chars = new char[cb.remaining()];
        cb.get(chars, 0, chars.length);
        return chars;
    }

    public static char[] toCharArrayUTF8(byte[] bytes) {
        Charset charset = StandardCharsets.UTF_8;
        return CharacterTools.toCharArray(bytes, charset);
    }

    public static char[] trim(char[] value) {
        int st;
        if (value == null) {
            return null;
        }
        int len = value.length;
        char[] val = value;
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < value.length ? Arrays.copyOfRange(value, st, len) : value;
    }

    private CharacterTools() {
    }
}

