/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.state;

import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.state.CommonState;
import de.intarsys.tools.state.ConcurrentState;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.state.IStateHolder;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;

public class StateVector
extends CommonState {
    private final List<ConcurrentState> states = new ArrayList<ConcurrentState>();

    protected void addState(ConcurrentState entry) {
        this.states.add(entry);
    }

    @Override
    public IState attach(IStateHolder stateHolder) {
        StateVector result = new StateVector();
        for (ConcurrentState entry : this.states) {
            result.addState((ConcurrentState)entry.attach(stateHolder));
        }
        return result;
    }

    @Override
    public void enterState(IState state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        if (this.states.size() == 1) {
            IState tempState = this.states.get(0);
            sb.append(tempState.getId());
        } else {
            sb.append("{");
            for (ConcurrentState entry : this.states) {
                sb.append(entry.getId());
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("}");
        }
        return sb.toString();
    }

    protected String createLabel(IMessageBundle messageBundle, List<String> path) {
        StringBuilder sb = new StringBuilder();
        for (ConcurrentState entry : this.states) {
            String label = entry.createLabel(messageBundle, new ArrayList<String>(path));
            if (StringTools.isEmpty(label)) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(label);
        }
        return sb.toString();
    }

    @Override
    protected String getPrefix() {
        return "(v)";
    }

    @Override
    public IState getRootState() {
        return this;
    }

    @Override
    public IState getState() {
        return null;
    }

    protected ConcurrentState getStateEntry(Object context) {
        for (ConcurrentState state : this.states) {
            if (state.getContext() != context) continue;
            return state;
        }
        return null;
    }

    public List<ConcurrentState> getStates() {
        return this.states;
    }

    @Override
    public boolean isAncestorOf(IState state) {
        return false;
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    @Override
    public boolean isFinal() {
        for (ConcurrentState state : this.states) {
            if (state.isFinal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInitial() {
        for (ConcurrentState state : this.states) {
            if (state.isInitial()) continue;
            return false;
        }
        return true;
    }

    public IState lookupState(Object context) {
        ConcurrentState state = this.getStateEntry(context);
        if (state == null) {
            return null;
        }
        return state.getContextState();
    }

    public StateVector putState(ConcurrentState state) {
        StateVector newState = new StateVector();
        boolean newContext = true;
        for (ConcurrentState entry : this.states) {
            if (entry.getContext() == state.getContext()) {
                newContext = false;
                if (state.getContextState() == AtomicState.DISPOSED) continue;
                newState.addState(state);
                continue;
            }
            newState.addState(entry);
        }
        if (state.getContextState() != AtomicState.DISPOSED && newContext) {
            newState.addState(state);
        }
        return newState;
    }

    public CommonState unwrap() {
        if (this.states.size() == 1) {
            return (CommonState)this.states.get(0).getContextState();
        }
        return this;
    }
}

