/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.state;

import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.state.CommonState;
import de.intarsys.tools.state.ConcurrentState;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.state.IStateHolder;
import de.intarsys.tools.state.StateVector;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;

public class ComplexState
extends CommonState
implements IPresentationSupport,
IMessageBundleSupport {
    protected static final IStateHolder UNASSIGNED = new UnassignedHolder();
    private final IState rootState;
    private final StateVector stateVector;
    private IStateHolder stateHolder = UNASSIGNED;
    private String label;

    protected static ComplexState create(IState rootState, StateVector subStates) {
        ComplexState newState = new ComplexState(rootState, subStates);
        return newState;
    }

    protected static ComplexState wrap(IState state) {
        if (state == null) {
            return null;
        }
        if (!(state instanceof ComplexState)) {
            return ComplexState.create(state, null);
        }
        return (ComplexState)state;
    }

    protected ComplexState(IState rootState, StateVector subStates) {
        if (rootState == null) {
            throw new NullPointerException();
        }
        this.rootState = rootState;
        this.stateVector = subStates != null ? (StateVector)subStates.attach(this) : null;
    }

    @Override
    public final IState attach(IStateHolder stateHolder) {
        if (stateHolder == null) {
            this.stateHolder = stateHolder;
            return null;
        }
        if (this.stateHolder == UNASSIGNED) {
            this.stateHolder = stateHolder;
            return this;
        }
        ComplexState result = new ComplexState(this.rootState, this.stateVector);
        return result.attach(stateHolder);
    }

    protected String createLabel() {
        IMessageBundle bundle = this.getMessageBundle();
        if (bundle == null) {
            return "{" + this.getId() + "}";
        }
        return this.createLabel(bundle, new ArrayList<String>());
    }

    protected String createLabel(IMessageBundle bundle, List<String> path) {
        path.add(this.rootState.getId());
        if (this.stateVector == null) {
            String pattern = this.getLabelPattern(bundle, new ArrayList<String>(path));
            if (pattern == null) {
                String id = StringTools.join(path, "/");
                return bundle.getString(id, new Object[0]);
            }
            return bundle.format(pattern, new Object[0]);
        }
        return this.stateVector.createLabel(bundle, new ArrayList<String>(path));
    }

    @Override
    public void enterState(IState pState) {
        if (pState == null) {
            throw new NullPointerException();
        }
        if (!(pState instanceof CommonState)) {
            throw new IllegalArgumentException();
        }
        ConcurrentState cState = ConcurrentState.create((CommonState)pState);
        StateVector newSubStates = null;
        if (this.stateVector == null) {
            newSubStates = new StateVector();
            if (cState.getContextState() != AtomicState.DISPOSED) {
                newSubStates.addState(cState);
            }
        } else {
            newSubStates = this.stateVector.putState(cState);
        }
        if (newSubStates.isEmpty()) {
            newSubStates = null;
        }
        ComplexState newState = new ComplexState(this.getRootState(), newSubStates);
        this.getStateHolder().enterState(newState);
    }

    @Override
    public String getDescription() {
        return this.getTip();
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRootState().getId());
        if (this.stateVector != null && !this.stateVector.isEmpty()) {
            sb.append("/");
            sb.append(this.stateVector.getId());
        }
        return sb.toString();
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            this.label = this.createLabel();
        }
        return this.label;
    }

    protected String getLabelPattern(IMessageBundle bundle, List<String> path) {
        String pattern = null;
        String id;
        while ((pattern = bundle.getPattern("state." + (id = StringTools.join(path, "/")) + ".label")) == null) {
            if (path.size() == 1) {
                return null;
            }
            path.remove(path.size() - 1);
        }
        return pattern;
    }

    @Override
    public IMessageBundle getMessageBundle() {
        if (this.getStateHolder() instanceof IMessageBundleSupport) {
            return ((IMessageBundleSupport)((Object)this.getStateHolder())).getMessageBundle();
        }
        return null;
    }

    @Override
    protected String getPrefix() {
        if (this.getStateHolder() == UNASSIGNED) {
            return "(x-)";
        }
        return "(x)";
    }

    @Override
    public IState getRootState() {
        return this.rootState;
    }

    @Override
    public IState getState() {
        if (this.stateVector == null) {
            return null;
        }
        return this.stateVector.unwrap();
    }

    public IStateHolder getStateHolder() {
        return this.stateHolder;
    }

    protected StateVector getStateVector() {
        return this.stateVector;
    }

    @Override
    public String getTip() {
        return this.getLabel();
    }

    @Override
    public boolean isAncestorOf(IState state) {
        return false;
    }

    @Override
    public boolean isFinal() {
        return this.getRootState().isFinal();
    }

    @Override
    public boolean isInitial() {
        return this.getRootState().isInitial();
    }

    static class UnassignedHolder
    implements IStateHolder {
        UnassignedHolder() {
        }

        @Override
        public void enterState(IState state) {
        }

        @Override
        public IState getState() {
            return null;
        }

        public String toString() {
            return "<unassigned>";
        }
    }
}

