/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.state;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.state.IStateHolder;

public class AtomicStateHolder
implements IStateHolder,
IMessageBundleSupport {
    private AtomicState state;
    private final Object owner;
    private IMessageBundle messageBundle;
    private final INotificationListener listener;

    public AtomicStateHolder(Object owner, INotificationListener listener) {
        this.owner = owner;
        this.listener = listener;
        this.enterState(AtomicState.NEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterState(IState pState) {
        if (pState == null) {
            throw new NullPointerException();
        }
        if (!(pState instanceof AtomicState)) {
            throw new IllegalArgumentException();
        }
        AtomicState oldState = null;
        AtomicStateHolder atomicStateHolder = this;
        synchronized (atomicStateHolder) {
            if (pState == this.state) {
                return;
            }
            oldState = this.state;
            this.state = (AtomicState)pState;
        }
        this.triggerChanged("state", oldState, pState);
    }

    @Override
    public IMessageBundle getMessageBundle() {
        if (this.messageBundle != null) {
            return this.messageBundle;
        }
        if (this.owner instanceof IMessageBundleSupport) {
            return ((IMessageBundleSupport)this.owner).getMessageBundle();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IState getState() {
        AtomicStateHolder atomicStateHolder = this;
        synchronized (atomicStateHolder) {
            return this.state;
        }
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    public String toString() {
        return "StateHolder@" + this.getState().getId();
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        if (this.listener != null) {
            this.listener.handleEvent(new AttributeChangedEvent(this.owner, attribute, oldValue, newValue));
        }
    }
}

